import cv2  
from PIL import Image, ImageEnhance,ImageColor
import gradio as gr
import numpy as np
import datetime

with gr.Blocks() as interface:

    with gr.Row():
        with gr.Accordion("1.请选择一张待加工图片"):
            img_input = gr.Image(label='图片',interactive=True)
    with gr.Row():
        with gr.Accordion("2.可更换勾边颜色，点加工图片"):
            color = gr.ColorPicker(label="勾边颜色")
            section_btn = gr.Button("加工图片")
    
    with gr.Accordion("【结果】4种勾边效果"):
        gr.Markdown("#### 手机下载图片，需长按图片2秒后松开，会出现保存方式")
        with gr.Row():
            closed_output0 = gr.Image(label='简单勾边')
            closed_output1 = gr.Image(label='常规勾边')
        
        with gr.Row():
            closed_output2 = gr.Image(label='细致勾边')
            closed_output3 = gr.Image(label='彩色勾边')


    # 调整模型结果参数
    def turn_arguments(img,color):
        imageX = Image.fromarray(img)
        contrast = ImageEnhance.Contrast(imageX)
        imageX = contrast.enhance(1.5)
        sharpness = ImageEnhance.Sharpness(imageX)
        imageX = sharpness.enhance(1.5)
        img = np.asarray(imageX)

        #####################################
        #   极简勾边-自选颜色                #
        #####################################
        gaussian_blur_0 = 13
        structuring_element_0 = 3
        canny_start_0 = 65
        canny_end_0 = 100
        thresh_val_0 = 205
        maxval_0 = 330
        blend = 0.4
        gray0 = cv2.cvtColor(img, cv2.COLOR_BGR2GRAY)
        # 对灰度图像进行高斯滤波，以去除噪声  
        gray0 = cv2.GaussianBlur(gray0, (gaussian_blur_0,gaussian_blur_0), 0)
        # 使用Canny算子进行边缘检测  
        edges0 = cv2.Canny(gray0, canny_start_0, canny_end_0)
        # 将边缘图像转换为二值图像  
        _, thresh0 = cv2.threshold(edges0, thresh_val_0, maxval_0, cv2.THRESH_BINARY) 
        # 对二值图像进行形态学操作，以去除小的噪点  
        kernel0 = cv2.getStructuringElement(cv2.MORPH_ELLIPSE, (structuring_element_0, structuring_element_0))  
        closed0 = cv2.morphologyEx(thresh0, cv2.MORPH_CLOSE, kernel0)
        closed0 = closed0.astype(img.dtype)
        result0 = cv2.bitwise_and(img, img, mask=closed0)
        result0[closed0==0] = (255,255,255)
        line_color0 = ImageColor.getcolor(color, "RGB")
        result0[closed0!=0] = (line_color0)
        close00 = Image.fromarray(result0).convert('RGB')

        # 颜色空间转换  
        image0 = Image.fromarray(img)
        enhancer0 = ImageEnhance.Color(image=image0)
        # 增强颜色  
        # img0 = enhancer0.enhance(enhance).convert('RGB')
        # union_img0 = np.asarray(Image.blend(close00, img0, blend))


        #####################################
        #   简单勾边-自选颜色                #
        #####################################
        gaussian_blur_1 = 13
        structuring_element_1 = 3
        canny_start_1 = 25
        canny_end_1 = 45
        thresh_val_1 = 205
        maxval_1 = 330
        gray1 = cv2.cvtColor(img, cv2.COLOR_BGR2GRAY)
        # 对灰度图像进行高斯滤波，以去除噪声  
        gray1 = cv2.GaussianBlur(gray1, (gaussian_blur_1,gaussian_blur_1), 0)
        # 使用Canny算子进行边缘检测  
        edges1 = cv2.Canny(gray1, canny_start_1, canny_end_1)
        # 将边缘图像转换为二值图像  
        _, thresh1 = cv2.threshold(edges1, thresh_val_1, maxval_1, cv2.THRESH_BINARY) 
        # 对二值图像进行形态学操作，以去除小的噪点  
        kernel1 = cv2.getStructuringElement(cv2.MORPH_ELLIPSE, (structuring_element_1, structuring_element_1))  
        closed1 = cv2.morphologyEx(thresh1, cv2.MORPH_CLOSE, kernel1)
        closed1 = closed1.astype(img.dtype)
        result1 = cv2.bitwise_and(img, img, mask=closed1)
        result1[closed1==0] = (255,255,255)
        line_color1 = ImageColor.getcolor(color, "RGB")
        result1[closed1!=0] = (line_color1)
        close01 = Image.fromarray(result1).convert('RGB')

        # 颜色空间转换  
        image1 = Image.fromarray(img)
        enhancer1 = ImageEnhance.Color(image=image1)
        # 增强颜色  
        # img1 = enhancer1.enhance(enhance).convert('RGB')
        # union_img1 = np.asarray(Image.blend(close01, img1, blend))

        #####################################
        #   复杂勾边-自选颜色                #
        #####################################
        gaussian_blur_2 = 13
        structuring_element_2 = 3
        canny_start_2 = 10
        canny_end_2 = 40
        thresh_val_2 = 205
        maxval_2 = 330
        gray2 = cv2.cvtColor(img, cv2.COLOR_BGR2GRAY) 
        # 对灰度图像进行高斯滤波，以去除噪声  
        gray2 = cv2.GaussianBlur(gray2, (gaussian_blur_2,gaussian_blur_2), 0)  
        # 使用Canny算子进行边缘检测  
        edges2 = cv2.Canny(gray2, canny_start_2, canny_end_2)
        # 将边缘图像转换为二值图像  
        _, thresh2 = cv2.threshold(edges2, thresh_val_2, maxval_2, cv2.THRESH_BINARY) 
        # 对二值图像进行形态学操作，以去除小的噪点  
        kernel2 = cv2.getStructuringElement(cv2.MORPH_ELLIPSE, (structuring_element_2, structuring_element_2))  
        closed2 = cv2.morphologyEx(thresh2, cv2.MORPH_CLOSE, kernel2)
        closed2 = closed2.astype(img.dtype)
        result2 = cv2.bitwise_and(img, img, mask=closed2)
        result2[closed2==0] = (255,255,255)
        line_color2 = ImageColor.getcolor(color, "RGB")
        result2[closed2!=0] = (line_color2)
        close02 = Image.fromarray(result2).convert('RGB')

        # 颜色空间转换  
        image2 = Image.fromarray(img)
        enhancer2 = ImageEnhance.Color(image=image2)
        # 增强颜色  
        # img2 = enhancer2.enhance(enhance).convert('RGB')
        # union_img2 = np.asarray(Image.blend(close02, img2, blend))

        #####################################
        #   简单勾边-彩色勾边                #
        #####################################
        closed3 = closed1.astype(img.dtype)
        result3 = cv2.bitwise_and(img, img, mask=closed3)
        result3[closed3==0] = (255,255,255)
        close03 = Image.fromarray(result3).convert('RGB')

        # 颜色空间转换  
        image3 = Image.fromarray(img)
        enhancer3 = ImageEnhance.Color(image=image3)
        # 增强颜色  
        # img3 = enhancer3.enhance(enhance).convert('RGB')
        # union_img3 = np.asarray(Image.blend(close03, img3, blend))

        # return result0,union_img0,result1,union_img1,result2,union_img2,result3,union_img3
        return result0,result1,result2,result3
    
    section_btn.click(turn_arguments,inputs=[img_input,color],
                      outputs = [closed_output0,closed_output1,closed_output2,closed_output3])
                                    # outputs = [closed_output0,img_param_output0,closed_output1,img_param_output1,closed_output2,img_param_output2,closed_output3,img_param_output3])
    
    def feed_back(fb_info):
        f = open('feedback.txt', mode='a',encoding='utf-8-sig')
        dt = datetime.datetime.now().strftime('%Y-%m-%d %H:%M:%S')
        result = f.writelines(dt+'   ,    '+fb_info+'\n')
        print('result->',result)
        f.close()
        return '我们已收到，谢谢反馈！'

    #####################################
    #            意见反馈                #
    #####################################
    with gr.Accordion("点击我，反馈意见 or 提出需求",open=False):
        gr.Markdown("功能免费，服务无价，欢迎给我们提出任何意见和建议，我们会尽快改进")
        with gr.Row():
            fb_info = gr.TextArea(label='反馈内容',lines=7,value='hi,')
        with gr.Row():
            rInfo = gr.Markdown()
        with gr.Row():
            fb_btn = gr.Button("反馈",elem_classes=".gradio-button {}")
    l = fb_btn.click(feed_back,inputs=[fb_info],outputs = [rInfo])
interface.launch(show_api=False)