---
sdk: streamlit
title: Exam-Cheating-Detector
emoji: 🚀
app_file: app.py
---
# AIComputerVision
This project contains various computer vision and AI related python scripts

Link to full playlist: https://www.youtube.com/watch?v=UM9oDhhAg88&list=PLWw98q-Xe7iH8UHARl8RGk8MRj1raY4Eh

Below is brief description for each script:

1. Cat Dog detection:
This script can detect cats and dogs in a frame. You can replace cat or dog with any other object you want to detect.

2. Centroidtracker:
This script helps in tracking any object in a frame. We have used this in person_tracking.py script in order to track persons in the frame.

3. Dwell Time Calculation:
This script calculates the time a person has spent in a frame. It is a good example of calculating total time a person was present in frame.

4. Face Detection:
This script detects face in person image or in a frame

5. FPS Example:
While inferencing on a video file or frame from a live usb webcam, it's always a good idea to keep a check on how much fps we are getting. This script shows approx fps on frame.

6. OpenCV Example:
This script shows the basic usage of OpenCV

7. Person Detection in Image File:
This script detects a person in an image file

8. Person Detection in Video File:
This script detects a person in the video file. Test video file is present in video dir.

9. Person Tracking:
This script detects people and keeps tracking them in the frame. It assigns a unique ID to each detected person.

10. Monitor Social Distance
This script monitors the social distance between the persons. If it is less than a threshold value, we display the bounding box in red otherwise green.

11. Drawing tracking line:
This script draws a line denoting where the person has entered in the frame and where he has moved in the frame. 

12. Face Mask Detection: 
This script checks if a person is wearing face mask or not

13. Person Counter:
This script counts the number of person present in the frame.