import gradio as gr
import torch
import torch.nn as nn
import torchvision
import torch.backends.cudnn as cudnn
import torch.optim
import os
import sys
import argparse
import dataloader
import model
import numpy as np
from torchvision import transforms
from PIL import Image
import glob


def lowlight(image):
	os.environ['CUDA_VISIBLE_DEVICES']=''
	data_lowlight = Image.open(image)
	
	data_lowlight = (np.asarray(data_lowlight)/255.0)
	data_lowlight = torch.from_numpy(data_lowlight).float()
	data_lowlight = data_lowlight.permute(2,0,1)
	data_lowlight = data_lowlight.cpu().unsqueeze(0)

	DCE_net = model.enhance_net_nopool().cpu()
	DCE_net.load_state_dict(torch.load('Epoch99.pth', map_location=torch.device('cpu')))
	
	_,enhanced_image,_ = DCE_net(data_lowlight)

	torchvision.utils.save_image(enhanced_image, f'01.png')

	return '01.png'


title = "Low-Light Image Enhancement using Zero-DCE"
description = "Gradio Demo for Low-Light Enhancement using Zero-DCE. The model improves the quality of images that have poor contrast, low brightness, and suboptimal exposure. To use it, simply upload your image, or click one of the examples to load them. Check out the original paper and the GitHub repo at the links below. "
article = "<p style='text-align: center'><a href='http://openaccess.thecvf.com/content_CVPR_2020/papers/Guo_Zero-Reference_Deep_Curve_Estimation_for_Low-Light_Image_Enhancement_CVPR_2020_paper.pdf' target='_blank'>Zero-Reference Deep Curve Estimation for Low-Light Image Enhancement</a> | <a href='https://github.com/Li-Chongyi/Zero-DCE' target='_blank'>Github Repo</a></p> <center><img src='https://visitor-badge.glitch.me/badge?page_id=52Hz_CMFNet_deblurring' alt='visitor badge'></center>"

examples = [['01.jpg'], ['02.jpg'], ['03.jpg'], ['04.png'], ['05.jpg'],]
gr.Interface(
    lowlight,
    [gr.inputs.Image(type="file", label="Input")],
    [gr.outputs.Image(type="file", label="Output")],
    title=title,
    description=description,
    article=article,
    allow_flagging=False,
    allow_screenshot=False,
    examples=examples
).launch(debug=True)
