#pip install gradio
#pip3 install torch
#pip install transformers --upgrade

import gradio as gr
from transformers import AutoTokenizer, AutoModelForSequenceClassification, pipeline

ckpt = 'mrm8488/distilroberta-finetuned-banking77'
tokenizer = AutoTokenizer.from_pretrained(ckpt)
model = AutoModelForSequenceClassification.from_pretrained(ckpt)

classifier = pipeline('text-classification', tokenizer=tokenizer, model=model)

demo= gr.Interface.from_pipeline(classifier)
demo.launch(share=True)