import os
import gradio as gr
import openai
from gtts import gTTS

# load the api key
openai.api_key = os.environ["OPEN_AI_KEY"]

# takes an audio file from the microphone
def transcribe(audio):   
        audio_file = open(audio, "rb")    
        transcript = openai.Audio.transcribe("whisper-1", audio_file)
        
        return transcript["text"]



# Create a Gradio App using Blocks    
with gr.Blocks() as demo:
    gr.Markdown(
    """
    # Welcome to ILyaz Ai Bot
    """
    )
    with gr.Accordion("Click for Instructions:"):
            gr.Markdown(
    """
    * Record your query.
    * Submit your query, and follow the chat or listen to the advice.
    * When you are ready to respond, clear your last recording and resubmit.
    note: Transcribe Audio does not work on iOS
    """)
        
    
    # First message as instructions to OpenAI
    messages = gr.State(value=[{"role": "system", "content": "This education app offers a personalized learning experience to students of different age groups and subjects through four menus. These menus are Learning Lessons, which include age-appropriate lessons with multimedia content and chat-based interactions for each curriculum topic. Interactive Tests, which offer assessments and quizzes to evaluate students' understanding of the material, one question at a time. Practical Exercises, which provide engaging hands-on activities and simulations to allow students to apply their knowledge. Progress Tracking & Rewards, which features a personalized dashboard to track progress, collect badges, and unlock achievements. Community & Support, which includes chat-based forums, leaderboards, and team-based challenges to foster collaboration and friendly competition. To input their age and preferred subject, students can type AGE and SUBJECT, respectively. The chat interface will offer five options, including learning lessons and tests, relevant to the student's age and subject. To minimize unnecessary responses, the app always asks one question at a time. When using the MENU type, the user will be returned to the main menu. The app's curriculum is based on the UK National Curriculum for secondary education, and it uses UK grammar instead of Americanized words." }])

    # Takes the users transcribed audio as a string
    def botResponse(user_input, messages):
        messages.append({"role": "user", "content": user_input})
        response = openai.ChatCompletion.create(
          model="gpt-3.5-turbo-0301",
          messages=messages
        )

        # Parse the response from OpenAI and store
        system_message = response["choices"][0]["message"]["content"]
        messages.append({"role": "assistant", "content": system_message})

        # Process the messages list to get the chat log into a string
        chat_transcript = ""
        for message in messages:
            if (message["role"] != "system"):
                chat_transcript += message["role"] + ": " + message["content"] + "\n\n"
    
        return chat_transcript

    # Gets the last message in the chat log and uses GTTS to convert the last response into an audio file.
    def giveVoice(messages):
        bot_message=messages[-1]
        
        myobj = gTTS(text=bot_message["content"])
        myobj.save("temp.mp3")
    
        dir = os.getcwd()
        new_path = os.path.join(dir, "temp.mp3")
    
        return new_path

    # Creates the Gradio interface objects
    with gr.Row():
        with gr.Column(scale=1):
            user_audio = gr.Audio(source="microphone", type="filepath", label="Input Phrase")
            submit_btn = gr.Button(value="Transcribe Audio")
            submit_btn2 = gr.Button(value="Submit Text")
            gpt_voice = gr.Audio(label="Listen to Advice")
        with gr.Column(scale=2):
            user_transcript = gr.Text(label="Audio Translation", interactive=False)
            user_text = gr.Text(label="Text Input")
            gpt_transcript = gr.Text(label="Chat Transcript")
    submit_btn.click(transcribe, user_audio, user_transcript)
    submit_btn2.click(botResponse, [user_text, messages], gpt_transcript)
    user_transcript.change(botResponse, [user_transcript, messages], gpt_transcript)
    gpt_transcript.change(giveVoice, messages, gpt_voice)
    
    
# creates a local web server
demo.launch(auth=("ILyaz", "hello"))