from flask import Flask, request, jsonify, make_response, render_template
from do_predict import predict_single

from dotenv import load_dotenv
load_dotenv()

app = Flask(__name__, template_folder="static", static_url_path="", static_folder="static")
app.config["JSON_AS_ASCII"] = False

@app.route("/")
def index():
        return render_template("index.html")

@app.before_request
def before():
    # handle preflight
    if request.method == "OPTIONS":
        resp = make_response()
        resp.headers["Access-Control-Allow-Origin"] = "*"
        resp.headers["Access-Control-Allow-Methods"] = "GET, POST"
        resp.headers["Access-Control-Allow-Headers"] = "Content-Type"
        return resp


@app.post("/api/predict_single")
def api_predict_single():
    text = request.json["text"]
    result = predict_single(text)
    resp = jsonify(result)
    resp.headers["Access-Control-Allow-Origin"] = "*"
    return resp


if __name__ == "__main__":
    app.run(host="0.0.0.0", port=7860)
