import gradio as gr
import plotly.express as px
import numpy as np
import wandb
import os
import pandas as pd

wandb_key = os.getenv("wandb_key")
proj_name = os.getenv("proj_name")
entity_proj_name = os.getenv("entity_proj_name")
wandb.login(key=wandb_key)
api = wandb.Api()

step=[]
loss=[]
runs = api.runs(entity_proj_name)
for run in runs:
    # if run.id not in ['dys9531f','kakfv1ab']:
    #     continue
    # print(run)
    history = run.scan_history(keys=['train/lm_loss','_step'])
    tmp_step=[]
    tmp_loss=[]
    for row in history:
        # if row['_step'] not in step
        tmp_step.append(row['_step'])
        tmp_loss.append(row['train/lm_loss'])
    if len(tmp_step)>35:
        step.extend(tmp_step)
        loss.extend(tmp_loss)


def get_plot(period=1):
    # run = api.run(proj_name)
    # df = run.history() 
    # history = run.scan_history(keys=['train/lm_loss','_step'])
    # step=[]
    # loss=[]
    # for row in history:
    #     step.append(row['_step'])
    #     loss.append(row['train/lm_loss'])
    
    # df=pd.DataFrame({'_step':step,'train/lm_loss':loss})
    # df.shape

    runs = api.runs(entity_proj_name)
    for run in runs:
        df = run.history()
        for i,row in df.iterrows():
            if row['_step'] not in step:
                step.append(row['_step'])
                loss.append(row['train/lm_loss'])

    df=pd.DataFrame({'_step':step,'train/lm_loss':loss})
    df=df.sort_values('_step', ascending=True)
    
    fig = px.line(df, x='_step', y='train/lm_loss', range_y=[0.8, 3.8], render_mode='webgl')
    return fig
 

with gr.Blocks() as demo:
    with gr.Row():
        with gr.Column():
            gr.Markdown("Ziya-Llama2-13B/train/lm_loss")
            plot = gr.Plot(label="Plot (updates every 12 second)")

    dep = demo.load(get_plot, None, plot, every=100)


  
if __name__ == "__main__":
    demo.queue().launch()