#!/usr/bin/env python

from __future__ import annotations

import gradio as gr

from paper_list import PaperList

DESCRIPTION = '# ICML 2023 Papers'

paper_list = PaperList()

with gr.Blocks(css='style.css') as demo:
    gr.Markdown(DESCRIPTION)

    search_box = gr.Textbox(
        label='Search Title',
        placeholder=
        'You can search for titles with regular expressions. e.g. (?<!sur)face'
    )
    case_sensitive = gr.Checkbox(label='Case Sensitive')
    filter_names = gr.CheckboxGroup(choices=[
        'arXiv',
        'GitHub',
        'Space',
        'Model',
        'Dataset',
    ],
                                    label='Filter')
    search_button = gr.Button('Search')

    number_of_papers = gr.Textbox(label='Number of Papers Found')
    table = gr.HTML(show_label=False)

    demo.load(
        fn=paper_list.render,
        inputs=[
            search_box,
            case_sensitive,
            filter_names,
        ],
        outputs=[
            number_of_papers,
            table,
        ],
    )

    search_box.submit(
        fn=paper_list.render,
        inputs=[
            search_box,
            case_sensitive,
            filter_names,
        ],
        outputs=[
            number_of_papers,
            table,
        ],
    )
    search_button.click(
        fn=paper_list.render,
        inputs=[
            search_box,
            case_sensitive,
            filter_names,
        ],
        outputs=[
            number_of_papers,
            table,
        ],
    )
demo.queue().launch()
