import os
import requests
import pandas as pd
import gradio as gr
from huggingface_hub.hf_api import SpaceInfo
from pathlib import Path


path = f"https://huggingface.co/api/spaces" 	

    
def get_blocks_party_spaces():
    r = requests.get(path)
    d = r.json()
    spaces = [SpaceInfo(**x) for x in d]
    blocks_spaces = {}
    for i in range(0,len(spaces)):
        if spaces[i].id.split('/')[0] == 'ICML2022' and hasattr(spaces[i], 'likes') and spaces[i].id != 'ICML2022/Leaderboard' and spaces[i].id != 'ICML2022/README':
            blocks_spaces[spaces[i].id]=spaces[i].likes
    df = pd.DataFrame(
    [{"Spaces_Name": Spaces, "likes": likes} for Spaces,likes in blocks_spaces.items()])
    df = df.sort_values(by=['likes'],ascending=False)
    return df


block = gr.Blocks()

with block:    
    gr.Markdown("""Leaderboard for the most popular ICML 2022 Spaces. To learn more and join, see <a href="https://huggingface.co/ICML2022" target="_blank" style="text-decoration: underline">ICML 2022 Event</a>""")
    with gr.Tabs():
        with gr.TabItem("ICML 2022 Leaderboard"):
            with gr.Row():
                data = gr.outputs.Dataframe(type="pandas")
            with gr.Row():
                data_run = gr.Button("Refresh")
                data_run.click(get_blocks_party_spaces, inputs=None, outputs=data)

    block.load(get_blocks_party_spaces, inputs=None, outputs=data)                
block.launch()
