import gradio as gr
from transformers import pipeline

generator = pipeline('text-generation', model = 'gpt2')

def generate(text):
  result = generator(text, max_length = 15, num_return_sequences = 1)
  return result[0]["generated_text"]

examples = [
    ["One fine day, three friends went to the movies, but could not decide what movie to watch. One friend said, "],
    ["The best headphones for music is,"],
]

demo = gr.Interface(
    fn = generate,
    inputs = gr.inputs.Textbox(lines = 5, label = "Input Text"),
    outputs = gr.outputs.Textbox(label = "Generated Text"),
    examples = examples
)

demo.launch()