import os
import gradio as gr

API_KEY=os.environ.get('HUGGING_FACE_HUB_TOKEN', None)

article = """---
This space was created using [SD Space Creator](https://huggingface.co/spaces/anzorq/sd-space-creator)."""

gr.Interface.load(
    name="models/dreamlike-art/dreamlike-photoreal-2.0",
    title="""Dreamlike Photoreal 2.0""",
    description="""Demo for <a href="https://huggingface.co/dreamlike-art/dreamlike-photoreal-2.0">Dreamlike Photoreal 2.0</a> Stable Diffusion model.""",
    article=article,
    api_key=API_KEY,
    ).queue(concurrency_count=20).launch()
