from transformers import pipeline
asr_pipe = pipeline("automatic-speech-recognition", model="Abdullah17/whisper-small-urdu")
from difflib import SequenceMatcher
import json




with open("tasks.json", "r",encoding="utf-8") as json_file:
    urdu_data = json.load(json_file)
# List of commands
# commands = [
#     "نمائندے ایجنٹ نمائندہ",
#     "  سم  ایکٹیویٹ ",
#     " سم  بلاک بند ",
#     "موبائل پیکیجز انٹرنیٹ پیکیج",
#     " چالان جمع چلان",
#     " گانا "
# ]
# replies = [
# 1,2,
# ]
# Function to find the most similar command
def find_most_similar_command(statement, command_list):
    best_match = None
    highest_similarity = 0
    reply=404
    # Using globals() to create a global variable
    for index,file_list in command_list.items():
     for command in  file_list:
        similarity = SequenceMatcher(None, statement, command).ratio()
        print(index,"similarity",similarity)
        if similarity > highest_similarity:
            highest_similarity = similarity
            best_match = command
            reply=index
    return best_match,reply

def transcribe_the_command(audio,menu_id,abc):
      import soundfile as sf
      sample_rate, audio_data = audio
      file_name = "recorded_audio.wav"
      sf.write(file_name, audio_data, sample_rate)
    # Convert stereo to mono by averaging the two channels
      print(menu_id)

      transcript = asr_pipe(file_name)["text"]
      commands=urdu_data[menu_id]
      print(commands)
      most_similar_command,reply = find_most_similar_command(transcript, commands)
      print(f"Given Statement: {transcript}")
      print(f"Most Similar Command: {most_similar_command}\n")
      print(reply)
      return reply
# get_text_from_voice("urdu.wav")
import gradio as gr


iface = gr.Interface(
    fn=transcribe_the_command,
    inputs=[gr.inputs.Audio(label="Recorded Audio",source="microphone"),gr.inputs.Textbox(label="menu_id"),gr.inputs.Textbox(label="dfs")],
    outputs="text",
    title="Whisper Small Urdu Command",
    description="Realtime demo for Urdu speech recognition using a fine-tuned Whisper small model and outputting the estimated command on the basis of speech transcript.",
)

iface.launch()