import gradio as gr
from huggingface_hub import hf_hub_download
from PIL import Image
import yolov5

# Downloading the model from HuggingFace
model_file = hf_hub_download(repo_id="HugoSchtr/yolov5_datacat", filename="best.pt")

model = yolov5.load(model_file)

# Prediction function
def predict(im, threshold=0.50):
    """
    Performs prediction using Datacat YOLOv5 model
    """

    # We could resize the image, but the application handles high definition for now
    # g = (size / max(im.size))  # gain
    # im = im.resize((int(x * g) for x in im.size), Image.ANTIALIAS)
    
    # initializing confidence threshold
    model.conf = threshold
    # inference
    results = model(im)
    numpy_image = results.render()[0]
    output_image = Image.fromarray(numpy_image)

    return output_image

title = "YOLOv5 - Auction sale catalogues layout analysis"

description = "<p style='text-align: center'>YOLOv5 Gradio demo for auction sales catalogues layout analysis. Detecting titles and catalogues entries.</p>"

article = "<p style='text-align: center'>YOLOv5 source code : <a href='https://github.com/ultralytics/yolov5'>Source code</a> | <a href='https://pytorch.org/hub/ultralytics_yolov5'>PyTorch Hub</a></p>"

examples = [['./img_examples/12148-bpt6k1240127r.pdf_page_20.png', 0.50],
            ['./img_examples/12148-bpt6k1240127r.pdf_page_21.png', 0.50],
            ['./img_examples/12148-bpt6k1240127r.pdf_page_27.png', 0.50],]

demo=gr.Interface(fn=predict,
            inputs=[gr.Image(type="pil", label="document image"), gr.Slider(maximum=1, step=0.01, value=0.50)],
            outputs=gr.Image(type="pil", label="annotated document").style(height=700),
            title=title,
            description=description,
            article=article,
            examples=examples,
            theme="huggingface")


if __name__ == "__main__":
    demo.launch(debug=True)
