# From https://github.com/6/stopwords-json
# From https://github.com/stopwords-iso/stopwords-iso for Urdu and Vietnamese


stopwords = {
    "af": [
        "'n",
        "aan",
        "af",
        "al",
        "as",
        "baie",
        "by",
        "daar",
        "dag",
        "dat",
        "die",
        "dit",
        "een",
        "ek",
        "en",
        "gaan",
        "gesê",
        "haar",
        "het",
        "hom",
        "hulle",
        "hy",
        "in",
        "is",
        "jou",
        "jy",
        "kan",
        "kom",
        "ma",
        "maar",
        "met",
        "my",
        "na",
        "nie",
        "om",
        "ons",
        "op",
        "saam",
        "sal",
        "se",
        "sien",
        "so",
        "sy",
        "te",
        "toe",
        "uit",
        "van",
        "vir",
        "was",
        "wat",
        "ŉ",
    ],
    "ar": [
        "آنذاك",
        "أبداً",
        "أثناء",
        "أسفل",
        "أعلى",
        "أغلب",
        "أكثر",
        "ألا",
        "ألم",
        "أم",
        "أمام",
        "أمس",
        "أن",
        "أنا",
        "أنت",
        "أنتم",
        "أنتما",
        "أنتن",
        "أو",
        "أولئك",
        "أي",
        "أيان",
        "أياً",
        "أية",
        "أيضاً",
        "أين",
        "أينما",
        "إبان",
        "إثر",
        "إثر ذلك",
        "إذا",
        "إزاء",
        "إلا",
        "إلا أن",
        "إلى",
        "إما",
        "إن",
        "إنما",
        "إياك",
        "إياكم",
        "إياكما",
        "إياكن",
        "إيانا",
        "إياه",
        "إياها",
        "إياهم",
        "إياهما",
        "إياهن",
        "إياي",
        "الآن",
        "البتة",
        "التي",
        "الذي",
        "الذين",
        "اللائي",
        "اللات",
        "اللاتي",
        "اللتان",
        "اللتين",
        "اللذان",
        "اللذين",
        "اللهم",
        "اللوات",
        "اللواتي",
        "الليلة",
        "اليوم",
        "اي",
        "بألا",
        "بأن",
        "بئس",
        "بئست",
        "باتجاه",
        "بالأخص",
        "بالأمس",
        "بالتالي",
        "بالذات",
        "بالرغم من",
        "بالضبط",
        "بالطبع",
        "بالفعل",
        "بالقرب",
        "بالكامل",
        "بالنسبة ل",
        "بتاتاً",
        "بجانب",
        "بحسب",
        "بحوالي",
        "بحيث",
        "بذلك",
        "برغم",
        "برمته",
        "بشتى",
        "بصرف النظر عن",
        "بضع",
        "بضعة",
        "بعد",
        "بعدما",
        "بعض",
        "بغض الطرف عن",
        "بغض النظر عن",
        "بغية",
        "بـ",
        "بقرب",
        "بل",
        "بلا",
        "بلى",
        "بم",
        "بما",
        "بما أن",
        "بمفرده",
        "بمقتضى",
        "بمنأى عن",
        "بموجب",
        "بين",
        "بينما",
        "تاماً",
        "تباعاً",
        "تبعاً",
        "تجاه",
        "تحت",
        "تحديداً",
        "تحسباً",
        "تقريباً",
        "تلك",
        "تلو",
        "تماماً",
        "تمشياً",
        "ثم",
        "ثمة",
        "جانب",
        "جاهداً",
        "جداً",
        "جدياً",
        "جراء",
        "جل",
        "جميع",
        "جميعاً",
        "جنوب",
        "جنوبي",
        "حتماً",
        "حتمياً",
        "حتى",
        "حسب",
        "حسبما",
        "حوالي",
        "حول",
        "حيال",
        "حيث",
        "حيث أن",
        "حيثما",
        "حين",
        "حينئذ",
        "حيناً",
        "حينذاك",
        "حينما",
        "خارج",
        "ختاماً",
        "خلال",
        "خلف",
        "دائماً",
        "داخل",
        "دوماً",
        "دون",
        "دونما",
        "ذاك",
        "ذلك",
        "رغم",
        "رغم أن",
        "ريثما",
        "زهاء",
        "ساعة",
        "سنة",
        "سوف",
        "سوى",
        "سوياً",
        "شتى",
        "شرق",
        "شريطة",
        "شكراً",
        "شمال",
        "صبيحة",
        "صوب",
        "ضد",
        "طالما",
        "طبقاً",
        "طواعية",
        "طوعاً",
        "طيلة",
        "عادة",
        "عام",
        "عامة",
        "عبر",
        "عدا",
        "عدة",
        "عسى",
        "عشية",
        "عقب",
        "علاوة على",
        "علاوة على ذلك",
        "على",
        "على الرغم من",
        "على حد قول",
        "على غرار",
        "على هذا",
        "عما",
        "عمن",
        "عموماً",
        "عن",
        "عند",
        "عندئذ",
        "عندما",
        "عنوة",
        "عوضا عن",
        "غالب",
        "غالباً",
        "غداة",
        "غداً",
        "غرب",
        "غير",
        "غير أن",
        "ـك",
        "ـكم",
        "ـكما",
        "ـكن",
        "ـنا",
        "ـه",
        "ـها",
        "ـهم",
        "ـهما",
        "ـهن",
        "ـي",
        "فجأة",
        "فجر",
        "فحسب",
        "فصاعداً",
        "فضلاً",
        "فـ",
        "فور",
        "فوراً",
        "فوق",
        "في",
        "في تلك الأثناء",
        "في غضون ذلك",
        "في هذه الأثناء",
        "فيما",
        "فيما يلي",
        "قبالة",
        "قبل",
        "قبيل",
        "قد",
        "قدماً",
        "قرابة",
        "قرب",
        "قسراً",
        "قطعياً",
        "قليلاً",
        "كأن",
        "كالمعتاد",
        "كثيراً",
        "كذا",
        "كذلك",
        "كـ",
        "كل",
        "كلا",
        "كلتا",
        "كلما",
        "كم",
        "كما",
        "كما أن",
        "كي",
        "كيف",
        "لأن",
        "لئلا",
        "لا",
        "لا بأس أن",
        "لا بد",
        "لا سيما",
        "لا لبس أن",
        "لا مانع",
        "لابد",
        "لاحقاً",
        "لاسيما",
        "لحظة",
        "لحوالي",
        "لدى",
        "لذا",
        "لذلك",
        "لعل",
        "لـ",
        "لقد",
        "لكن",
        "لكي",
        "للتو",
        "لم",
        "لما",
        "لماذا",
        "لن",
        "لو",
        "لولا",
        "ليت",
        "ليلة",
        "مؤخراً",
        "مؤقتاً",
        "ما",
        "ماذا",
        "مباشرة",
        "متى",
        "مثل",
        "مثلاً",
        "مثلما",
        "مجاناً",
        "مجدداً",
        "مجرد",
        "محض",
        "مراراً",
        "مساء",
        "مطلقاً",
        "مع",
        "مع أن",
        "مع ذلك",
        "معاً",
        "معظم",
        "مما",
        "مما زاد الطين بلة",
        "مما يزيد الطين بلة",
        "ممن",
        "من",
        "من الجدير بالذكر أن",
        "من المؤسف",
        "من المؤكد",
        "من المؤمل",
        "من المرجح",
        "من المفترض",
        "من الممكن",
        "من ثم",
        "من جهة أخرى",
        "من غير المرجح",
        "من غير الممكن",
        "من ناحية أخرى",
        "منذ",
        "مهما",
        "نادراً",
        "ناهيك عن",
        "نحن",
        "نحو",
        "نسبياً",
        "نعم",
        "نعمت",
        "نفس",
        "نهار",
        "نهاراً",
        "هؤلاء",
        "هاتان",
        "هاتين",
        "هدراً",
        "هذا",
        "هذان",
        "هذه",
        "هذين",
        "هكذا",
        "هكذا دواليك",
        "هل",
        "هم",
        "هما",
        "هن",
        "هنا",
        "هناك",
        "هنالك",
        "هو",
        "هي",
        "و",
        "وراء",
        "وسط",
        "وفق",
        "وفقاً",
        "وقت",
        "وقتما",
        "يا",
        "يذكر أن",
        "يوم",
        "يوماً",
        "يومياً",
    ],
    "as": [
        "অন্যথা",
        "অৱশ্যে",
        "আপোনাৰ",
        "উদাহৰণস্বৰূপে",
        "ওপৰলৈ",
        "কম",
        "কাৰণ",
        "কিন্তু",
        "কেতিয়াবা",
        "কোনোবা",
        "গতিকে",
        "তললৈ",
        "তাৰ সলনি",
        "তাৰে ভিতৰত",
        "তেওঁলোকৰ",
        "তেতিয়া",
        "তেনেকুৱাই",
        "ফালে",
        "বহুত",
        "বাওঁফালে",
        "বাহিৰত",
        "ভিতৰত",
        "মোৰ",
        "যথেষ্ট",
        "যাৰ",
        "যি",
        "যেতিয়ালৈকে",
        "যেনে",
        "লৈ",
        "সকলোৱে",
        "সোঁফালে",
        "সৰ্বাধিক",
    ],
    "bn": [
        "অনেক",
        "অনেক ",
        "অন্য ",
        "অন্যথায়",
        "আমরা ",
        "আমার ",
        "আমি",
        "আর জন্য ",
        "আর, ও, এবং ",
        "আরও সাথে , আরো সঙ্গে ",
        "উদাহরণ স্বরূপ",
        "উপর",
        "এ ",
        "এ, এটা, এইটা ",
        "এখানে , এইখানে  ",
        "ও ,ওটা ,ওইটা",
        "ওখানে, সেখানে ",
        "ওদের মধ্যে ",
        "কখন ",
        "কখনও কখনও",
        "কম, অল্প ",
        "কারণ ",
        "কি",
        "কিছু ",
        "কিন্তু ",
        "কে ",
        "কেউ",
        "কেমন ",
        "কোথায়",
        "কোনটা ",
        "ডান",
        "তাই, সুতরাং",
        "তার, তাদের, ওর, ওদের ",
        "তারপর",
        "তারা ",
        "তুমি, আপনি ",
        "তোমরা , আপনারা ",
        "তোমার, তোর ",
        "দিকে",
        "না ",
        "নিচে",
        "পরিবর্তে , বরং ",
        "পর্যন্ত",
        "বাইরে",
        "বাম",
        "ভিতর",
        "ভিতরে",
        "মত",
        "যতক্ষণ না",
        "যথেষ্ট",
        "যদি ",
        "যাহার",
        "যাহোক",
        "সব, সবাই ",
        "সবাই",
        "সর্বাধিক",
        "সামান্য",
        "সে রকমই",
        "সে, ও",
    ],
    "ca": [
        "-ho",
        "-la",
        "-lo",
        "-ne",
        "-se",
        "a",
        "abans",
        "això",
        "al",
        "algun",
        "alguna",
        "algunes",
        "alguns",
        "algú",
        "allò",
        "als",
        "altra",
        "altre",
        "altres",
        "amb",
        "aqueix",
        "aqueixa",
        "aqueixes",
        "aqueixos",
        "aquell",
        "aquella",
        "aquelles",
        "aquells",
        "aquest",
        "aquesta",
        "aquestes",
        "aquestos",
        "aquests",
        "bastant",
        "bastants",
        "bé",
        "cada",
        "cadascun",
        "cadascuna",
        "cadascú",
        "cap",
        "cert",
        "certa",
        "certes",
        "certs",
        "com",
        "con",
        "contra",
        "d",
        "d'",
        "da",
        "damunt",
        "darrere",
        "davant",
        "de",
        "del",
        "dels",
        "des",
        "dient",
        "diferent",
        "diferents",
        "dins",
        "dintre",
        "dir",
        "divers",
        "diverses",
        "diversos",
        "durant",
        "eixa",
        "eixe",
        "eixes",
        "eixos",
        "el",
        "ell",
        "ella",
        "elles",
        "ells",
        "els",
        "em",
        "emperò",
        "en",
        "endavant",
        "enfront",
        "ens",
        "entre",
        "envers",
        "era",
        "eren",
        "es",
        "estan",
        "estant",
        "estar",
        "estaran",
        "estarem",
        "estaria",
        "estarien",
        "estarà",
        "estat",
        "estava",
        "estaven",
        "este",
        "estem",
        "estes",
        "esteu",
        "estic",
        "estiguem",
        "estiguessin",
        "estigui",
        "estiguin",
        "estigués",
        "estos",
        "està",
        "et",
        "ets",
        "excepte",
        "extra",
        "fa",
        "faci",
        "facin",
        "facis",
        "faig",
        "fan",
        "faran",
        "farem",
        "fareu",
        "faria",
        "farien",
        "faries",
        "faràs",
        "faràs",
        "faré",
        "faríem",
        "faríeu",
        "fas",
        "feia",
        "feien",
        "feies",
        "fem",
        "fent",
        "fer",
        "fes",
        "fessin",
        "fessis",
        "fet",
        "feu",
        "fins",
        "foren",
        "fos",
        "fossin",
        "fou",
        "front",
        "fèiem",
        "fèieu",
        "féssiu",
        "gaire",
        "gaires",
        "gràcies",
        "ha",
        "hagi",
        "hagin",
        "haguem",
        "haguessin",
        "haguessis",
        "hagut",
        "hagués",
        "haguéssim",
        "haguéssin",
        "haguéssiu",
        "han",
        "has",
        "hauran",
        "haurem",
        "haureu",
        "hauria",
        "haurien",
        "hauries",
        "haurà",
        "hauràs",
        "hauré",
        "hauríem",
        "hauríeu",
        "havent",
        "haver",
        "havia",
        "havien",
        "havies",
        "havíem",
        "havíeu",
        "he",
        "hem",
        "heu",
        "hi",
        "ho",
        "hom",
        "hàgim",
        "i",
        "in",
        "jo",
        "l",
        "l",
        "l'",
        "la",
        "las",
        "les",
        "li",
        "llur",
        "llurs",
        "lo",
        "los",
        "ls",
        "m",
        "m",
        "m'",
        "malgrat",
        "mancant",
        "massa",
        "mateix",
        "mateixa",
        "mateixes",
        "mateixos",
        "me",
        "mentre",
        "menys",
        "mes",
        "meu",
        "meus",
        "meva",
        "meves",
        "mi",
        "mitjançant",
        "molt",
        "molta",
        "moltes",
        "molts",
        "moltíssim",
        "moltíssima",
        "moltíssimes",
        "moltíssims",
        "n",
        "n'",
        "ne",
        "ni",
        "ningun",
        "ninguna",
        "ningunes",
        "ninguns",
        "ningú",
        "no",
        "nombroses",
        "nombrós",
        "nos",
        "nosaltres",
        "nostra",
        "nostre",
        "nostres",
        "ns",
        "o",
        "on",
        "os",
        "pel",
        "pels",
        "per",
        "perqu",
        "perquè",
        "però",
        "poc",
        "poca",
        "pocs",
        "poques",
        "prou",
        "qual",
        "quals",
        "qualsevol",
        "quan",
        "quant",
        "quantes",
        "quants",
        "que",
        "quelcom",
        "qui",
        "quin",
        "quina",
        "quines",
        "quins",
        "què",
        "rere",
        "respecte",
        "s",
        "s",
        "s'",
        "sa",
        "sabent",
        "salvant",
        "se",
        "segons",
        "sens",
        "sense",
        "sent",
        "ser",
        "seran",
        "serem",
        "seria",
        "serien",
        "serà",
        "seré",
        "seríem",
        "ses",
        "seu",
        "seus",
        "seva",
        "seves",
        "si",
        "siguem",
        "sigui",
        "siguin",
        "sigut",
        "sinó",
        "sobre",
        "som",
        "sota",
        "su",
        "suficient",
        "séssim",
        "sóc",
        "són",
        "t",
        "t'",
        "tal",
        "tals",
        "tant",
        "tanta",
        "tantes",
        "tants",
        "te",
        "tenc",
        "tendran",
        "tendrem",
        "tendreu",
        "tendria",
        "tendrien",
        "tendries",
        "tendràs",
        "tendràs",
        "tendré",
        "tendríem",
        "tendríeu",
        "tenen",
        "tenia",
        "tenien",
        "tenies teníem",
        "tenim",
        "tenir",
        "teniu",
        "tens",
        "teníeu",
        "teu",
        "teus",
        "teva",
        "ti",
        "tinc",
        "tindran",
        "tindre",
        "tindrem",
        "tindreu",
        "tindria",
        "tindrien",
        "tindries",
        "tindràs",
        "tindràs",
        "tindré",
        "tindríem",
        "tindríeu",
        "tingut",
        "tot",
        "tota",
        "total",
        "totes",
        "tothom",
        "tots",
        "tu",
        "té",
        "u",
        "ultra",
        "un",
        "una",
        "unes",
        "uns",
        "us",
        "va",
        "vagi",
        "vagin",
        "vaig",
        "vam",
        "van",
        "varen",
        "vau",
        "vers",
        "versus",
        "via",
        "vora",
        "vos",
        "vosaltres",
        "vostre",
        "vostè",
        "vostès",
        "vàrem",
        "y",
        "érem",
        "és",
    ],
    "en": [
        "a",
        "a.k.a",
        "aboard",
        "about",
        "above",
        "abt",
        "accord",
        "according",
        "across",
        "after",
        "against",
        "ago",
        "aground",
        "ahead",
        "aka",
        "ala",
        "albeit",
        "all",
        "along",
        "alongside",
        "although",
        "am",
        "amid",
        "amidst",
        "among",
        "amongst",
        "amoung",
        "an",
        "and",
        "and/or",
        "another",
        "any",
        "any1",
        "anybody",
        "anyone",
        "anything",
        "are",
        "around",
        "as",
        "aside",
        "astride",
        "at",
        "atop",
        "away",
        "b",
        "b/c",
        "b/t",
        "back",
        "base",
        "based",
        "bc",
        "be",
        "because",
        "been",
        "before",
        "behind",
        "being",
        "below",
        "beneath",
        "beside",
        "besides",
        "between",
        "beyond",
        "board",
        "both",
        "btwn",
        "but",
        "by",
        "can",
        "cause",
        "circa",
        "cos",
        "could",
        "coz",
        "cus",
        "depend",
        "depending",
        "despite",
        "did",
        "do",
        "does",
        "down",
        "due",
        "during",
        "each",
        "either",
        "else",
        "even",
        "ever",
        "every",
        "everybody",
        "everyone",
        "everything",
        "except",
        "for",
        "forth",
        "from",
        "get",
        "gets",
        "getting",
        "give",
        "given",
        "got",
        "had",
        "half",
        "has",
        "hav",
        "have",
        "having",
        "he",
        "her",
        "hers",
        "herself",
        "him",
        "himself",
        "his",
        "how",
        "however",
        "i",
        "i'd",
        "if",
        "in",
        "include",
        "including",
        "inside",
        "instead",
        "into",
        "is",
        "it",
        "it's",
        "its",
        "itself",
        "lest",
        "like",
        "made",
        "many",
        "may",
        "me",
        "might",
        "mine",
        "minus",
        "most",
        "much",
        "must",
        "my",
        "myself",
        "nary",
        "near",
        "nearby",
        "neither",
        "next",
        "nigh",
        "no",
        "nobody",
        "none",
        "noone",
        "nor",
        "not",
        "nothing",
        "notwithstanding",
        "of",
        "off",
        "on",
        "onboard",
        "once",
        "one",
        "ones",
        "oneself",
        "only",
        "onto",
        "opposite",
        "or",
        "other",
        "others",
        "ought",
        "our",
        "ours",
        "ourselves",
        "out",
        "outside",
        "over",
        "overt",
        "own",
        "past",
        "per",
        "plus",
        "prior",
        "quite",
        "rather",
        "re",
        "regard",
        "regarding",
        "regardless",
        "round",
        "s/he",
        "save",
        "self",
        "shall",
        "she",
        "should",
        "side",
        "since",
        "so",
        "some",
        "somebody",
        "someone",
        "something",
        "such",
        "sure",
        "teh",
        "than",
        "thanks",
        "that",
        "the",
        "their",
        "theirs",
        "them",
        "themselves",
        "then",
        "there",
        "these",
        "they",
        "they're",
        "thier",
        "this",
        "tho",
        "those",
        "thou",
        "though",
        "through",
        "throughout",
        "thru",
        "thy",
        "til",
        "till",
        "to",
        "together",
        "too",
        "toward",
        "towards",
        "u",
        "under",
        "underneath",
        "unless",
        "unlike",
        "until",
        "unto",
        "up",
        "upon",
        "ur",
        "us",
        "use",
        "versus",
        "via",
        "vs",
        "vs.",
        "w/",
        "w/o",
        "w/out",
        "was",
        "we",
        "were",
        "what",
        "whatever",
        "whatnot",
        "when",
        "whenever",
        "where",
        "whereas",
        "wherever",
        "whether",
        "which",
        "while",
        "whilst",
        "whither",
        "who",
        "who's",
        "whoever",
        "whom",
        "whomever",
        "whose",
        "why",
        "will",
        "with",
        "within",
        "without",
        "wo",
        "worth",
        "would",
        "wud",
        "y'all",
        "ya",
        "yet",
        "yo",
        "you",
        "you're",
        "your",
        "youre",
        "yours",
        "yourself",
        "yourselves",
    ],
    "es": [
        "a",
        "a fin de que",
        "a medida que",
        "a menos que",
        "a modo de",
        "a no ser que",
        "a poco que",
        "a que",
        "abandono",
        "acerca",
        "acostumbra",
        "adónde",
        "ahora",
        "al igual que",
        "al lado de",
        "algo",
        "alguien",
        "alguna",
        "algunas",
        "alguno",
        "algunos",
        "algún",
        "alrededor",
        "ambas",
        "ambos",
        "ante",
        "aparece",
        "aparecen",
        "apareció",
        "aparte",
        "apenas",
        "aquel",
        "aquella",
        "aquellas",
        "aquello",
        "aquellos",
        "aquesa",
        "aquesas",
        "aquesos",
        "aquesta",
        "aquestas",
        "aquesto",
        "aquestos",
        "aquél",
        "aquélla",
        "aquéllas",
        "aquéllos",
        "arrepentir",
        "arrepentiréis",
        "así",
        "así como",
        "así que",
        "atlético",
        "aun",
        "aunque",
        "aún",
        "bajo",
        "bastante",
        "bastantes",
        "bien",
        "cada",
        "casi",
        "cerca",
        "chance",
        "cierta",
        "ciertas",
        "cierto",
        "ciertos",
        "comenzado",
        "comenzó",
        "comienzan",
        "como",
        "como quiera que",
        "como si",
        "con",
        "con tal de",
        "con tal que",
        "conforme",
        "conmigo",
        "conque",
        "considera",
        "consideradas",
        "consideran",
        "consideró",
        "consigo",
        "contendrán",
        "contigo",
        "continuaba",
        "continuar",
        "continuaron",
        "continuase",
        "continuó",
        "continúa",
        "contra",
        "corresponden",
        "corresponder",
        "cual",
        "cual si",
        "cuales",
        "cualesquier",
        "cualesquiera",
        "cualquier",
        "cualquiera",
        "cuan",
        "cuando",
        "cuanta",
        "cuantas",
        "cuanto",
        "cuanto quiera que",
        "cuantos",
        "cuya",
        "cuyas",
        "cuyo",
        "cuyos",
        "cuàles",
        "cuál",
        "cuáles",
        "cuán",
        "cuándo",
        "cuánta",
        "cuántas",
        "cuánto",
        "cuántos",
        "cómo",
        "da",
        "dado que",
        "dar",
        "de",
        "de manera que",
        "de modo que",
        "deba",
        "debajo",
        "deban",
        "debas",
        "debe",
        "debemos",
        "deben",
        "deber",
        "deberá",
        "deberán",
        "debería",
        "deberíamos",
        "deberían",
        "debes",
        "debido",
        "debiera",
        "debieron",
        "debimos",
        "debió",
        "debo",
        "debía",
        "debíamos",
        "debían",
        "declaraba",
        "declarada",
        "declarado",
        "declarase",
        "declaro",
        "declaró",
        "dejaban",
        "dejado",
        "dejan",
        "dejará",
        "del",
        "delante",
        "demasiada",
        "demasiadas",
        "demasiado",
        "demasiados",
        "demás",
        "den",
        "dentro",
        "dentro_de",
        "des",
        "desde",
        "después",
        "detrás",
        "di",
        "dicha",
        "dichas",
        "dicho",
        "dichos",
        "diferente",
        "diferentes",
        "distintas",
        "distinto",
        "distintos",
        "diversas",
        "diverso",
        "diversos",
        "don",
        "donde",
        "dos",
        "durante",
        "dónde",
        "echar",
        "el",
        "el que",
        "ella",
        "ellas",
        "ello",
        "ellos",
        "en",
        "en cambio",
        "en caso de",
        "en la medida en que",
        "en tanto que",
        "encima",
        "enfrente",
        "entonces",
        "entre",
        "era",
        "eramos",
        "eran",
        "eras",
        "eres",
        "ergo",
        "es",
        "esa",
        "esas",
        "escasa",
        "escasas",
        "escaso",
        "escasos",
        "escrito",
        "ese",
        "eso",
        "eso que",
        "esos",
        "esotra",
        "esotro",
        "esta",
        "estaba",
        "estabais",
        "estabamos",
        "estaban",
        "estabas",
        "estado",
        "estamos",
        "estan",
        "estando",
        "estar",
        "estaremos",
        "estará",
        "estarán",
        "estaré",
        "estaría",
        "estaríamos",
        "estarían",
        "estarías",
        "estas",
        "este",
        "estemos",
        "esto",
        "estos",
        "estotra",
        "estotro",
        "estoy",
        "estuve",
        "estuviera",
        "estuvieran",
        "estuvieron",
        "estuviese",
        "estuviesen",
        "estuvimos",
        "estuvo",
        "está",
        "estábamos",
        "estáis",
        "están",
        "estás",
        "esté",
        "estén",
        "ex",
        "excepto",
        "frente",
        "fue",
        "fuera",
        "fueran",
        "fuere",
        "fueron",
        "fuese",
        "fuesen",
        "fui",
        "fuimos",
        "gracias",
        "gracias_a",
        "habeis",
        "haber",
        "haberle",
        "haberse",
        "habido",
        "habiendo",
        "habiéndo",
        "habremos",
        "habrá",
        "habrán",
        "habrás",
        "habré",
        "habría",
        "habríamos",
        "habrían",
        "habéis",
        "había",
        "habíamos",
        "habían",
        "habías",
        "hace",
        "hacer",
        "hacia",
        "hacía",
        "halla",
        "han",
        "has",
        "hasta",
        "hasta que",
        "hay",
        "haya",
        "hayamos",
        "hayan",
        "hayas",
        "he",
        "hecho",
        "hemos",
        "hola",
        "hubiera",
        "hubieran",
        "hubieron",
        "hubiese",
        "hubiesen",
        "hubiéramos",
        "hubo",
        "iba",
        "iban",
        "ido",
        "incluso",
        "ir",
        "irá",
        "irán",
        "iré",
        "iría",
        "junto a",
        "la",
        "las",
        "le",
        "lejos",
        "les",
        "lo",
        "los",
        "luego",
        "mal que",
        "mas",
        "me",
        "mediante",
        "menos",
        "mes",
        "mi",
        "mientras",
        "mientras que",
        "mis",
        "misma",
        "mismas",
        "mismo",
        "mismos",
        "mismísimo",
        "morir",
        "moriría",
        "mostrado",
        "mostraron",
        "mucha",
        "muchas",
        "muchisimas",
        "muchisimio",
        "muchisimo",
        "mucho",
        "muchos",
        "muchísima",
        "muchísimas",
        "muchísimo",
        "muchísimos",
        "más",
        "más bien",
        "mí",
        "mía",
        "mías",
        "mío",
        "míos",
        "nada",
        "nadie",
        "negar",
        "ni",
        "ni que",
        "ningun",
        "ninguna",
        "ningunas",
        "ninguno",
        "ningunos",
        "ningún",
        "no",
        "no obstante",
        "noche",
        "nombrado",
        "nombró",
        "nos",
        "nosotros",
        "nuestra",
        "nuestras",
        "nuestro",
        "nuestros",
        "o",
        "os",
        "otra",
        "otras",
        "otro",
        "otros",
        "pa",
        "para",
        "para que",
        "parezca",
        "partir",
        "pasar",
        "pero",
        "po",
        "poca",
        "pocas",
        "poco",
        "pocos",
        "podamos",
        "podeis",
        "podemos",
        "poder",
        "podes",
        "podido",
        "podras",
        "podre",
        "podremos",
        "podriaís",
        "podrá",
        "podrán",
        "podrás",
        "podré",
        "podréis",
        "podría",
        "podríamos",
        "podrían",
        "podéis",
        "podía",
        "podíamos",
        "podían",
        "poner",
        "poquito",
        "por",
        "por el contrario",
        "por ende",
        "por eso",
        "por lo que",
        "por mucho que",
        "por más que",
        "por no hablar de",
        "por si",
        "porque",
        "pos",
        "post",
        "pre",
        "pro",
        "propia",
        "propias",
        "propio",
        "propios",
        "pude",
        "pudiendo",
        "pudiera",
        "pudieran",
        "pudieras",
        "pudieron",
        "pudiese",
        "pudiesen",
        "pudimos",
        "pudo",
        "pueda",
        "puedan",
        "puedas",
        "puede",
        "pueden",
        "puedes",
        "puedo",
        "pues",
        "puesto",
        "puesto que",
        "que",
        "queda",
        "quedaba",
        "quedan",
        "quedó",
        "queremos",
        "querer",
        "queriendo",
        "quien",
        "quienes",
        "quienesquiera",
        "quienquier",
        "quienquiera",
        "quiera",
        "quiere",
        "quisiera",
        "quién",
        "quiénes",
        "qué",
        "re",
        "resulta",
        "resultado",
        "resultaría",
        "resulte",
        "sabe",
        "saber",
        "sabiendo",
        "salen",
        "salir",
        "salió",
        "salvo",
        "se",
        "sea",
        "seamos",
        "sean",
        "seas",
        "seguir",
        "seguirá",
        "seguía",
        "según",
        "semejante",
        "semejantes",
        "semi",
        "sendas",
        "sendo",
        "sendos",
        "ser",
        "será",
        "serán",
        "serás",
        "seré",
        "seréis",
        "sería",
        "serían",
        "serías",
        "si",
        "si bien",
        "si y solo si",
        "sido",
        "siempre que",
        "siendo",
        "siente",
        "siento",
        "siga",
        "sigamos",
        "sigue",
        "sin",
        "sino",
        "siquiera",
        "sobre",
        "sobrer",
        "sobrir",
        "soler",
        "solían",
        "somos",
        "son",
        "soy",
        "sub",
        "suele",
        "suelen",
        "suelo",
        "super",
        "supo",
        "sur",
        "sus",
        "suya",
        "suyas",
        "suyo",
        "suyos",
        "sé",
        "sí",
        "tal",
        "tales",
        "tanta",
        "tantas",
        "tanto",
        "tantos",
        "tantísima",
        "tantísimas",
        "tantísimos",
        "te",
        "tendremos",
        "tendrian",
        "tendrá",
        "tendrán",
        "tendría",
        "tendrían",
        "tenemos",
        "tener",
        "tenga",
        "tengan",
        "tengo",
        "tenia",
        "tenido",
        "teniendo",
        "tenéis",
        "tenía",
        "teníamos",
        "tenían",
        "terminas",
        "ti",
        "tiene",
        "tienen",
        "tienes",
        "toda",
        "todas",
        "todavía",
        "todes",
        "todo",
        "todos",
        "trabajado",
        "trans",
        "tras",
        "tu",
        "tus",
        "tuve",
        "tuviera",
        "tuvieron",
        "tuviese",
        "tuvo",
        "tuya",
        "tuyas",
        "tuyo",
        "tuyos",
        "tú",
        "u",
        "un",
        "una",
        "unas",
        "une",
        "unir",
        "uno",
        "unos",
        "usted",
        "ustedes",
        "va",
        "vamos",
        "van",
        "varias",
        "varios",
        "varía",
        "vas",
        "vaya",
        "vayan",
        "venir",
        "venía",
        "ver",
        "vice",
        "vieron",
        "vino",
        "vis a vis",
        "visto que",
        "volver",
        "volverá",
        "volveríamos",
        "volvió",
        "vos",
        "vosotras",
        "vosotros",
        "voy",
        "vuelva",
        "vuelvan",
        "vuelve",
        "vuelven",
        "vuestra",
        "vuestras",
        "vuestro",
        "vuestros",
        "vía",
        "y",
        "ya",
        "ya que",
        "yo",
        "ámbos",
        "él",
        "éramos",
        "ésa",
        "ésas",
        "ése",
        "ésos",
        "ésta",
        "éstas",
        "éste",
        "ésto",
        "éstos",
        "íbamos",
        "ó",
        "ú",
        "última",
        "últimas",
        "último",
        "últimos",
        "\ufeffdesde",
        "\ufeffel",
        "\ufeffen",
        "\ufeffla",
        "\ufefflas",
    ],
    "eu": [
        "*edin",
        "*edun",
        "*ezan",
        "aitzitik",
        "ala",
        "alabaina",
        "aldiz",
        "alegia",
        "alta",
        "anitz",
        "anitzek",
        "anitzeko",
        "anitzez",
        "antzera",
        "arabera",
        "ari",
        "ari_izan",
        "ariko",
        "arren",
        "asko",
        "askoan",
        "askok",
        "askoko",
        "askorekin",
        "askoren",
        "askorengan",
        "askorentzat",
        "askori",
        "askorik",
        "askotako",
        "askotan",
        "askotariko",
        "askotatik",
        "askotaz",
        "askotxo",
        "askoz",
        "at",
        "aunitz",
        "aurka",
        "aurkako",
        "aurretik",
        "azpian",
        "azpitik",
        "ba",
        "bada",
        "badago",
        "badezake",
        "badidazu",
        "badiezu",
        "badio",
        "badiogu",
        "badiote",
        "badiougu",
        "badiozu",
        "badira",
        "badirela",
        "baditu",
        "baditugu",
        "badituzte",
        "badituzu",
        "badu",
        "badugu",
        "badugun",
        "badut",
        "badute",
        "baduzu",
        "bagara",
        "bagatzaizkio",
        "bagenu",
        "baginen",
        "bai",
        "baietz",
        "baikaituzte",
        "bailegoen",
        "bailituen",
        "bailitzake",
        "bailitzateke",
        "baina",
        "bainan",
        "bainintzen",
        "bainizkion",
        "baino",
        "baita",
        "baitabil",
        "baitaiteke",
        "baitan",
        "baitaude",
        "baitiete",
        "baitigu",
        "baitio",
        "baitiote",
        "baitira",
        "baititu",
        "baititugu",
        "baitituzte",
        "baitituzu",
        "baititzaket",
        "baitizkio",
        "baitu",
        "baitugu",
        "baitute",
        "baituzu",
        "baitzaio",
        "baitzaizkio",
        "baitzara",
        "baitzegoen",
        "baitzen",
        "baitzeuden",
        "baitzien",
        "baitzion",
        "baitzioten",
        "baitziren",
        "baitzitekeen",
        "baitzituen",
        "baitzitzaion",
        "baitzuen",
        "baitzuten",
        "baizik",
        "baizituen",
        "baldin",
        "balego",
        "balira",
        "baliteke",
        "balitu",
        "balituzkete",
        "balitz",
        "balitzait",
        "balu",
        "balute",
        "banintz",
        "banitu",
        "banu",
        "barik",
        "barru",
        "bat",
        "batera",
        "batera\x97",
        "batere",
        "batzu",
        "batzuei",
        "batzuek",
        "batzuekin",
        "batzuen",
        "batzuengatik",
        "batzuentzat",
        "batzuetako",
        "batzuetakoak",
        "batzuetan",
        "batzuetara",
        "batzuetatik",
        "batzuez",
        "batzuk",
        "batzutako",
        "batzutan",
        "bazaigu",
        "bazaizu",
        "bazara",
        "bazen",
        "bazina",
        "baziren",
        "bazituen",
        "bazituzten",
        "bazuen",
        "bazuten",
        "bederen",
        "behintzat",
        "bera",
        "beragatik",
        "beraiei",
        "beraiek",
        "beraiekin",
        "beraien",
        "beraietaz",
        "berak",
        "berarekin",
        "beraren",
        "berarengan",
        "berarengana",
        "berarengandik",
        "berarengatik",
        "berarentzat",
        "berari",
        "berauek",
        "berauen",
        "berauetan",
        "beraz",
        "berbera",
        "berberagatik",
        "berberak",
        "berberarekin",
        "berberaren",
        "berberera",
        "bere",
        "berea",
        "bereak",
        "berean",
        "berek",
        "bereko",
        "berekoa",
        "berekoak",
        "beren",
        "beretan",
        "beretik",
        "beretzat",
        "berriz",
        "bertze",
        "bertzeekin",
        "bertzela",
        "bestalde",
        "bestaldean",
        "beste",
        "bestea",
        "besteak",
        "bestean",
        "bestearekiko",
        "bestearekin",
        "bestearen",
        "bestearengandik",
        "besteari",
        "besteaz",
        "besteei",
        "besteen",
        "besteengandik",
        "besteetan",
        "besteko",
        "bestekoa",
        "bestela",
        "bestera",
        "besterantz",
        "besterik",
        "bestetan",
        "bestetik",
        "bezala",
        "bezalako",
        "bezalakoa",
        "bezalakoen",
        "bidez",
        "bitartean",
        "bitarteko",
        "bitarterako",
        "bitartez",
        "da",
        "dabil",
        "dabiltza",
        "dadila",
        "dadin",
        "dago",
        "dagoela",
        "dagoelako",
        "dagoen",
        "dagoena",
        "dagoenaren",
        "dagoenean",
        "dagoenez",
        "daiteekenaren",
        "daiteke",
        "daitekeela",
        "daitekeen",
        "daitekeena",
        "daitekeenaren",
        "daitekeenez",
        "daiteken",
        "daitezela",
        "daitezen",
        "daitezke",
        "daitezkeelako",
        "daitezkeelarik",
        "daitezkeen",
        "daitezkeenak",
        "daitezkela",
        "dakizuke",
        "danok",
        "daude",
        "daudela",
        "daudelako",
        "dauden",
        "daudenak",
        "daudenek",
        "daudenen",
        "daudenik",
        "dautzuet",
        "dela",
        "delako",
        "delarik",
        "den",
        "dena",
        "denak",
        "denaren",
        "denarentzat",
        "denari",
        "denean",
        "denek",
        "denen",
        "denera",
        "denerako",
        "denetan",
        "denetarik",
        "denetik",
        "denez",
        "denik",
        "denok",
        "denon",
        "denona",
        "denontzat",
        "deus",
        "dexente",
        "dezadan",
        "dezagun",
        "dezake",
        "dezakedala",
        "dezakedan",
        "dezakedanean",
        "dezakeela",
        "dezakeen",
        "dezakeena",
        "dezakegu",
        "dezakegula",
        "dezakegun",
        "dezakela",
        "dezakelako",
        "dezaket",
        "dezakete",
        "dezaketela",
        "dezaketen",
        "dezakezu",
        "dezakezuen",
        "dezakezuenez",
        "dezakezunez",
        "dezala",
        "dezan",
        "dezaten",
        "dezente",
        "dezenterekin",
        "dezentetan",
        "diat",
        "didala",
        "didana",
        "didate",
        "didazue",
        "die",
        "diegu",
        "diegun",
        "diela",
        "dien",
        "dienak",
        "diet",
        "diete",
        "dietela",
        "dietelako",
        "dietenean",
        "diezaiekete",
        "diezaiokeena",
        "diezaiokete",
        "diezaiola",
        "diezaioten",
        "diezaizkioke",
        "diezazkioke",
        "diezazkiokeen",
        "digu",
        "digun",
        "digute",
        "digutela",
        "diguten",
        "digutenean",
        "diguzu",
        "dik",
        "din",
        "dinat",
        "dio",
        "diogu",
        "diogulako",
        "diogun",
        "diola",
        "dion",
        "diona",
        "dionean",
        "dionez",
        "diot",
        "diote",
        "diotela",
        "dioten",
        "diotena",
        "diotenak",
        "diotenek",
        "diozu",
        "dira",
        "direla",
        "direlako",
        "direlakoan",
        "direlakotz",
        "diren",
        "direnak",
        "direnean",
        "direnek",
        "direnen",
        "direnetan",
        "direnez",
        "direnik",
        "dit",
        "ditake",
        "ditazke",
        "ditin",
        "ditu",
        "ditudala",
        "ditudalako",
        "ditudan",
        "ditudanean",
        "dituela",
        "dituelako",
        "dituelarik",
        "dituen",
        "dituena",
        "dituenak",
        "dituenean",
        "ditugu",
        "ditugula",
        "ditugun",
        "ditugunez",
        "ditun",
        "ditut",
        "dituzte",
        "dituztela",
        "dituztelako",
        "dituzten",
        "dituztenak",
        "dituztenean",
        "dituztenek",
        "dituztenekin",
        "dituztenen",
        "dituzu",
        "dituzue",
        "dituzuen",
        "dituzula",
        "dituzun",
        "dituzunik",
        "ditzagun",
        "ditzake",
        "ditzakeen",
        "ditzakegu",
        "ditzakegula",
        "ditzakete",
        "ditzaketela",
        "ditzaketelako",
        "ditzaketen",
        "ditzakezu",
        "ditzan",
        "dizkidazu",
        "dizkie",
        "dizkien",
        "dizkiet",
        "dizkiete",
        "dizkigu",
        "dizkigula",
        "dizkigunak",
        "dizkigute",
        "dizkio",
        "dizkiola",
        "dizkion",
        "dizkiot",
        "dizkiotela",
        "dizkit",
        "dizkizuet",
        "dizkizugu",
        "dizu",
        "dizuet",
        "dizugu",
        "dizut",
        "dizute",
        "du",
        "duan",
        "dudala",
        "dudalarik",
        "dudan",
        "dudanak",
        "dudanarekin",
        "dudanean",
        "dudanik",
        "duela",
        "duelako",
        "duelakoan",
        "duen",
        "duena",
        "duenak",
        "duenaren",
        "duenarentzat",
        "duenari",
        "duenean",
        "duenentz",
        "duenez",
        "duenik",
        "dugu",
        "dugula",
        "dugulako",
        "dugun",
        "duguna",
        "dugunari",
        "dugunean",
        "dugunez",
        "dugunik",
        "duk",
        "dun",
        "dunala",
        "dut",
        "dute",
        "dutela",
        "dutelako",
        "dutelakoan",
        "duten",
        "dutena",
        "dutenagatik",
        "dutenak",
        "dutenaren",
        "dutenean",
        "dutenek",
        "duteneko",
        "dutenen",
        "dutenena",
        "dutenenetatik",
        "dutenentz",
        "dutenetakoa",
        "dutenetik",
        "dutenez",
        "duzu",
        "duzue",
        "duzuela",
        "duzuen",
        "duzuenean",
        "duzuenez",
        "duzula",
        "duzun",
        "duzunarekin",
        "ea",
        "edo",
        "edonor",
        "edota",
        "edozein",
        "edozeinek",
        "edozer",
        "edozertarako",
        "elgarrekin",
        "elgarri",
        "elkar",
        "elkarrekiko",
        "elkarrekin",
        "elkarren",
        "elkarri",
        "ene",
        "era",
        "ere",
        "esker",
        "eta",
        "eurak",
        "eurei",
        "eurek",
        "eurekin",
        "euren",
        "eurentzat",
        "ez",
        "ezan",
        "ezazu",
        "ezazue",
        "ezean",
        "ezein",
        "ezen",
        "ezer",
        "ezerekin",
        "ezerk",
        "ezertarako",
        "ezertaz",
        "ezertxo",
        "ezetz",
        "ezik",
        "ezta",
        "gabe",
        "gabeko",
        "gainera",
        "gainerakoan",
        "gainerat",
        "gainera\x97",
        "gainetik",
        "gaitezen",
        "gaitezke",
        "gaitezkeela",
        "gaitu",
        "gaituela",
        "gaituzte",
        "gaituztenak",
        "gara",
        "garela",
        "garelako",
        "garen",
        "garenez",
        "garenok",
        "gaude",
        "gaudenak",
        "gehiago",
        "gehiagoan",
        "gehiagok",
        "gehiagoko",
        "gehiagorekin",
        "gehiegi",
        "gehiegirik",
        "gehiegitxo",
        "gehien",
        "gehiena",
        "gehienak",
        "gehienek",
        "gehienekin",
        "gehienentzako",
        "gehienentzat",
        "gehienetako",
        "gehienetan",
        "gehienok",
        "gehientsu",
        "gehientsuen",
        "gehitxo",
        "gehixeago",
        "genbiltzan",
        "genezake",
        "genien",
        "genion",
        "genituela",
        "genituelako",
        "genituen",
        "genituzke",
        "genituzkeelako",
        "genizkion",
        "genizuen",
        "genizun",
        "genuela",
        "genuelako",
        "genuen",
        "genuenean",
        "genuenetik",
        "genuenez",
        "genuke",
        "genukeen",
        "geratu",
        "geratzen",
        "geroztik",
        "geu",
        "geure",
        "geuregan",
        "geuri",
        "ginela",
        "ginen",
        "ginenean",
        "ginenekoa",
        "gintezkeela",
        "gintuen",
        "gintuenagatik",
        "gintunan",
        "gintuzten",
        "gintzaizkion",
        "gu",
        "guk",
        "gure",
        "gurean",
        "gurekin",
        "guretzat",
        "guri",
        "gutako",
        "gutaz",
        "guti",
        "gutiz",
        "gutiz-gehien",
        "gutiz-gehienek",
        "gutxi",
        "gutxiago",
        "gutxiagorako",
        "gutxiagorekin",
        "gutxian",
        "gutxien",
        "gutxienez",
        "gutxik",
        "gutxiko",
        "gutxira",
        "gutxiren",
        "gutxitan",
        "guzi",
        "guziak",
        "guziarekin",
        "guziekin",
        "guzientzat",
        "guzti",
        "guztia",
        "guztiagatik",
        "guztiak",
        "guztian",
        "guztiarekin",
        "guztiaren",
        "guztiari",
        "guztiaz",
        "guztiei",
        "guztiek",
        "guztien",
        "guztiengan",
        "guztientzako",
        "guztientzat",
        "guztietako",
        "guztietan",
        "guztietara",
        "guztietatik",
        "guztiez",
        "guztioi",
        "guztiok",
        "guztion",
        "guztionak",
        "guztionen",
        "guztiontzat",
        "guztira",
        "guztitako",
        "haatik",
        "haiek",
        "haiekin",
        "haien",
        "haiengan",
        "haiengandik",
        "haietako",
        "haietan",
        "haietatik",
        "hainbat",
        "hainbatek",
        "hainbaten",
        "hainbatez",
        "hainbertze",
        "hainbeste",
        "hainbesterako",
        "haiteke",
        "haiz",
        "halaber",
        "halere",
        "harekin",
        "haren",
        "harena",
        "harentzat",
        "hargatik",
        "hari",
        "hark",
        "hartako",
        "hartan",
        "hartara",
        "hartarako",
        "hartatik",
        "hau",
        "haudala",
        "hauei",
        "hauek",
        "hauekin",
        "hauen",
        "hauetako",
        "hauetan",
        "hauetara",
        "hauetarako",
        "hauetarik",
        "hauetatik",
        "hauexek",
        "hauez",
        "hauxe",
        "heu",
        "heure",
        "hhriek",
        "hi",
        "hik",
        "hinduan",
        "hintzen",
        "hire",
        "hiri",
        "honegatik",
        "honek",
        "honekin",
        "honen",
        "honengatik",
        "honentzat",
        "honetako",
        "honetan",
        "honetara",
        "honetarako",
        "honetatik",
        "honetaz",
        "honez",
        "honi",
        "hori",
        "horiei",
        "horiek",
        "horiekin",
        "horien",
        "horientzat",
        "horietako",
        "horietakoren",
        "horietan",
        "horietarako",
        "horietariko",
        "horietatik",
        "horiez",
        "horixe",
        "horregatik",
        "horrek",
        "horrekin",
        "horren",
        "horrenbeste",
        "horrenbestez",
        "horrengatik",
        "horretako",
        "horretan",
        "horretantxe",
        "horretara",
        "horretarako",
        "horretatik",
        "horretaz",
        "horrexegatik",
        "horrexekin",
        "horrexetan",
        "horrez",
        "horrezaz",
        "horri",
        "hortaz",
        "huan",
        "huntan",
        "hura",
        "huraxe",
        "iezaidazu",
        "iezaiezu",
        "iezaion",
        "iezaiozu",
        "inor",
        "inoren",
        "inorentzako",
        "inori",
        "inork",
        "inortaz",
        "irian",
        "itzazu",
        "izaki",
        "kontra",
        "lezake",
        "lezakeen",
        "lezakete",
        "lezan",
        "liekeela",
        "liezaiokeen",
        "lioke",
        "liokeela",
        "liokeen",
        "lirateke",
        "liratekeela",
        "liteke",
        "litekeela",
        "litekeen",
        "litekeena",
        "litezke",
        "lituzkeela",
        "lituzkeen",
        "lituzkete",
        "litzaidake",
        "litzaiguke",
        "litzateke",
        "litzatekeela",
        "litzatekeelako",
        "litzatekela",
        "lizateke",
        "luke",
        "lukeela",
        "lukeelako",
        "lukeen",
        "lukeena",
        "lukete",
        "luketen",
        "nabil",
        "nago",
        "nahiko",
        "nahikoa",
        "nahikorik",
        "nahiz",
        "naiteke",
        "naiz",
        "naizela",
        "naizen",
        "naizenean",
        "naizenetan",
        "naizenetik",
        "naizenez",
        "naizenik",
        "nau",
        "nauen",
        "nauenarentzat",
        "nauenean",
        "nauk",
        "naun",
        "naute",
        "nautela",
        "nauzu",
        "nauzun",
        "nazan",
        "nazaten",
        "nazazu",
        "nazazun",
        "nenbilen",
        "nengoela",
        "nengoen",
        "nere",
        "neu",
        "neuk",
        "neure",
        "nezake",
        "ni",
        "nian",
        "nien",
        "nigan",
        "nik",
        "ninduen",
        "ninduten",
        "nintekeela",
        "nintzaion",
        "nintzateke",
        "nintzatekeela",
        "nintzela",
        "nintzelako",
        "nintzen",
        "nintzenean",
        "nion",
        "nire",
        "nirea",
        "niregan",
        "niregana",
        "niregatik",
        "nirekin",
        "niretzako",
        "niretzat",
        "niri",
        "nitaz",
        "nituela",
        "nituen",
        "nituzke",
        "nizuke",
        "nor",
        "norbait",
        "norbaitek",
        "norbaitekin",
        "norbaiten",
        "norbaitengana",
        "norbaitentzat",
        "norbaiti",
        "norbera",
        "norberak",
        "norberaren",
        "norbere",
        "noren",
        "nori",
        "nork",
        "nornahi",
        "nornahik",
        "nortzuk",
        "nortzuren",
        "nuela",
        "nuen",
        "nuena",
        "nuenean",
        "nuenetik",
        "nuke",
        "nukeela",
        "omen",
        "ondoan",
        "ondoko",
        "ondora",
        "ondoren",
        "ondorengo",
        "ondotik",
        "ordea",
        "ordez",
        "orduan",
        "oro_har",
        "orobat",
        "orohar",
        "orok",
        "ororen",
        "orori",
        "ostean",
        "ostera",
        "osterantzean",
        "pean",
        "piskat",
        "pixka_bat",
        "pixkat",
        "pranko",
        "ugari",
        "ugarik",
        "ugarirekin",
        "ugariren",
        "ugaritan",
        "zagok",
        "zaidan",
        "zaidanaren",
        "zaie",
        "zaiela",
        "zaien",
        "zaienez",
        "zaigu",
        "zaigun",
        "zaiguna",
        "zaigunean",
        "zaik",
        "zaio",
        "zaiola",
        "zaiolako",
        "zaion",
        "zaiona",
        "zait",
        "zaitez",
        "zaitezen",
        "zaitu",
        "zaitut",
        "zaituzte",
        "zaitzakegu",
        "zaizkidan",
        "zaizkie",
        "zaizkiela",
        "zaizkien",
        "zaizkigu",
        "zaizkio",
        "zaizkiola",
        "zaizkion",
        "zaizkit",
        "zaizkizu",
        "zaizkizue",
        "zaizkizun",
        "zaizu",
        "zaizue",
        "zara",
        "zarela",
        "zarete",
        "zatekeela",
        "zatekeen",
        "zatzait",
        "zaude",
        "ze",
        "zebilen",
        "zedin",
        "zegoan",
        "zegoela",
        "zegoelako",
        "zegoen",
        "zegoenez",
        "zegok",
        "zehar",
        "zein",
        "zeina",
        "zeinek",
        "zeinen",
        "zeintzu",
        "zeintzuetan",
        "zeintzuk",
        "zela",
        "zelako",
        "zelarik",
        "zen",
        "zena",
        "zenak",
        "zenarekin",
        "zenari",
        "zenbait",
        "zenbaitek",
        "zenbaiten",
        "zenbaitetan",
        "zenbaiti",
        "zenbaitzuk",
        "zenbat",
        "zenbateraino",
        "zenean",
        "zenekoa",
        "zenetik",
        "zenez",
        "zeniguten",
        "zenigutenez",
        "zenik",
        "zenituen",
        "zenitzakeen",
        "zenuela",
        "zenuen",
        "zenuke",
        "zenukete",
        "zenutela",
        "zenuten",
        "zeozer",
        "zer",
        "zer_edo_zer",
        "zerbait",
        "zerbaitek",
        "zerbaitengatik",
        "zerbaitetarako",
        "zeren",
        "zerendako",
        "zeri",
        "zerk",
        "zertan",
        "zertara",
        "zertarako",
        "zertaz",
        "zertxobait",
        "zeu",
        "zeudela",
        "zeudelako",
        "zeuden",
        "zeudenak",
        "zeuk",
        "zeure",
        "zezakeen",
        "zezaken",
        "zezaketen",
        "zezala",
        "zezan",
        "zezaten",
        "zidan",
        "zidatelako",
        "zidaten",
        "zidatena",
        "zidatenak",
        "zidatenean",
        "ziela",
        "zien",
        "zienez",
        "zietela",
        "zietelako",
        "zieten",
        "ziezaion",
        "zigun",
        "zigunez",
        "ziguten",
        "zinan",
        "zinen",
        "zintudan",
        "zintuztela",
        "zintuztenean",
        "ziola",
        "ziolako",
        "ziolarik",
        "zion",
        "ziona",
        "zionean",
        "zionez",
        "zioten",
        "ziotenak",
        "zirela",
        "zirelako",
        "zirelakoan",
        "zirelarik",
        "ziren",
        "zirenak",
        "zirenean",
        "zirenetik",
        "zirenez",
        "zirenik",
        "ziren\x97",
        "zirezte",
        "zitekeela",
        "zitekeen",
        "zitekeena",
        "zitekeenik",
        "zitezen",
        "zitezkeela",
        "zitezkeelakoan",
        "zitezkeen",
        "zituela",
        "zituelako",
        "zituelarik",
        "zituen",
        "zituenean",
        "zituenei",
        "zituztela",
        "zituztelarik",
        "zituzten",
        "zituztenak",
        "zituztenetik",
        "zitzaidakeen",
        "zitzaidala",
        "zitzaidan",
        "zitzaien",
        "zitzaigun",
        "zitzaiola",
        "zitzaion",
        "zitzaionagatik",
        "zitzaionean",
        "zitzaizkidan",
        "zitzaizkien",
        "zitzaizkienean",
        "zitzaizkigun",
        "zitzaizkion",
        "zitzaizkon",
        "zitzaizun",
        "zitzakeen",
        "zitzaketenak",
        "zizioten",
        "zizkidaten",
        "zizkien",
        "zizkienik",
        "zizkieten",
        "zizkigun",
        "zizkiola",
        "zizkion",
        "zizkiona",
        "zizkioten",
        "zizkiotenekin",
        "zizuen",
        "zizun",
        "zoin",
        "zonbat",
        "zu",
        "zuei",
        "zuek",
        "zuela",
        "zuelako",
        "zuelarik",
        "zuen",
        "zuena",
        "zuenak",
        "zuenarentzat",
        "zuenean",
        "zuenetik",
        "zuenez",
        "zuenik",
        "zuentzako",
        "zuetako",
        "zuetaz",
        "zugandik",
        "zuk",
        "zukeen",
        "zuketen",
        "zure",
        "zureak",
        "zurekin",
        "zuretzat",
        "zutela",
        "zutelako",
        "zutelarik",
        "zuten",
        "zutena",
        "zutenean",
        "zuteneko",
        "zutenetik",
        "zutenez",
    ],
    "fr": [
        "a",
        "afin",
        "ai",
        "aie",
        "aient",
        "ainsi",
        "ait",
        "alias",
        "aller",
        "allons",
        "apres",
        "après",
        "as",
        "au",
        "au-delà",
        "aucun",
        "aucune",
        "aucunes",
        "aucuns",
        "aujourd'",
        "auprès",
        "auquel",
        "aura",
        "aurai",
        "auraient",
        "aurais",
        "aurait",
        "aurions",
        "aurons",
        "auront",
        "autant",
        "autour",
        "autre",
        "autres",
        "autrui",
        "auxquelles",
        "auxquels",
        "avaient",
        "avais",
        "avait",
        "avant",
        "avec",
        "avez",
        "aviez",
        "avions",
        "avoir",
        "avons",
        "ayant",
        "ayez",
        "ayons",
        "beaucoup",
        "c'est-à-dire",
        "c-à-d.",
        "ca",
        "car",
        "ce",
        "ceci",
        "cela",
        "celle",
        "celle-ci",
        "celles",
        "celles-ci",
        "celui",
        "celui-ci",
        "celui-là",
        "cent",
        "certain",
        "certaine",
        "certaines",
        "certains",
        "ces",
        "cet",
        "cette",
        "ceux",
        "ceux-ci",
        "ceux-là",
        "cf.",
        "chacun",
        "chacune",
        "chaque",
        "chez",
        "ci",
        "cinq",
        "combien",
        "comme",
        "comment",
        "concernant",
        "contre",
        "cà",
        "d'après",
        "d'autres",
        "dans",
        "de",
        "dehors",
        "depuis",
        "derrière",
        "des",
        "deux",
        "devait",
        "devant",
        "devez",
        "devions",
        "devoir",
        "devons",
        "devra",
        "devraient",
        "devrait",
        "devrions",
        "devrons",
        "devront",
        "doit",
        "doivent",
        "donc",
        "dont",
        "du",
        "durant",
        "dès",
        "début",
        "dû",
        "elle",
        "elle-même",
        "elles",
        "elles-mêmes",
        "en",
        "entre",
        "entres",
        "envers",
        "environ",
        "es",
        "est",
        "et",
        "etaient",
        "etant",
        "etre",
        "eut",
        "eux",
        "eux-mêmes",
        "excepté",
        "eût",
        "faire",
        "fais",
        "faisaient",
        "faisait",
        "faisant",
        "fait",
        "faite",
        "faites",
        "fasse",
        "fassent",
        "fera",
        "ferait",
        "feront",
        "firent",
        "fit",
        "font",
        "furent",
        "fussent",
        "fut",
        "fût",
        "für",
        "grâce",
        "hormis",
        "hors",
        "i",
        "il",
        "ils",
        "iront",
        "je",
        "jusque",
        "l'on",
        "la",
        "ladite",
        "laquelle",
        "le",
        "le/lui",
        "ledit",
        "lequel",
        "les",
        "lesdites",
        "lesquelles",
        "lesquels",
        "leur",
        "leurs",
        "lors",
        "lorsque",
        "lui",
        "lui-aussi",
        "lui-même",
        "là",
        "ma",
        "maint",
        "maintes",
        "mais",
        "malgré",
        "me",
        "mes",
        "mien",
        "moi",
        "moi-même",
        "moins",
        "mon",
        "ne",
        "ni",
        "nonobstant",
        "nos",
        "notre",
        "nous",
        "nous-mêmes",
        "nul",
        "nôtre",
        "nôtres",
        "on",
        "ont",
        "onze",
        "ou",
        "outre",
        "où",
        "par",
        "parce",
        "parmi",
        "pas",
        "pendant",
        "personne",
        "peu",
        "peut",
        "peuvent",
        "peux",
        "plupart",
        "plus",
        "plusieurs",
        "pour",
        "pourquoi",
        "pourra",
        "pourraient",
        "pourrait",
        "pourrez",
        "pourrons",
        "pourront",
        "pouvait",
        "pouvez",
        "pouvoir",
        "pouvons",
        "presque",
        "près",
        "pu",
        "puis",
        "puisque",
        "puisse",
        "puissent",
        "puissions",
        "qu",
        "quand",
        "quant",
        "quarante",
        "quatre",
        "que",
        "quel",
        "quelconque",
        "quelle",
        "quelles",
        "quelqu'un",
        "quelque",
        "quelques",
        "quelques-unes",
        "quelques-uns",
        "quelqu’un",
        "quels",
        "qui",
        "quiconque",
        "quid",
        "quoi",
        "quoique",
        "rien",
        "sa",
        "sans",
        "sauf",
        "se",
        "selon",
        "sera",
        "serai",
        "seraient",
        "serais",
        "serait",
        "seras",
        "serez",
        "seriez",
        "serions",
        "serons",
        "seront",
        "ses",
        "si",
        "sien",
        "sienne",
        "siennes",
        "siens",
        "sinon",
        "six",
        "soi",
        "soi-même",
        "soient",
        "sois",
        "soit",
        "sommes",
        "son",
        "sont",
        "sous",
        "soyez",
        "soyons",
        "suis",
        "sur",
        "t-il",
        "ta",
        "tandis",
        "tant",
        "tantôt",
        "te",
        "tel",
        "telle",
        "telles",
        "tes",
        "tien",
        "toi",
        "ton",
        "tous",
        "tout",
        "toute",
        "toutes",
        "trois",
        "tte",
        "tu",
        "un",
        "une",
        "unes",
        "uns",
        "unt",
        "va",
        "vais",
        "van",
        "vers",
        "versus",
        "via",
        "voici",
        "voilà",
        "voir",
        "voire",
        "vont",
        "vos",
        "votre",
        "vous",
        "vous-même",
        "vs",
        "vu",
        "y",
        "à",
        "á",
        "ça",
        "étaient",
        "étais",
        "était",
        "étant",
        "étiez",
        "étions",
        "été",
        "êtes",
        "être",
    ],
    "gu": [
        "અંદર",
        "અડધા, અડધું",
        "અત્યારે, હમણાં",
        "અથવા, કે",
        "અને",
        "અનેક, ઘણા",
        "અન્ય, બીજું",
        "અમને, હમેં",
        "અમારા",
        "અમારું, આપણું",
        "અમે",
        "અહીં, અહીંયા",
        "આ",
        "આ દ્વારા",
        "આ રીતે, આ તરફ",
        "આની જેમ",
        "ઉપર",
        "એકલા",
        "એનાથી",
        "એમાથી",
        "ઓછું, ઓછા",
        "કઈ બાજુ",
        "કદાચ",
        "કયું, કયો, કઈ, જે",
        "કાં તો",
        "કેટલા",
        "કેટલાક, થોડા",
        "કેમ, શા માટે",
        "કેવી રીતે, કઈ રીતે",
        "કોઈ",
        "કોઈ નહી",
        "કોઈને",
        "કોઈપણ",
        "કોણ",
        "કોનું, જેમના, જેમની",
        "ક્યાંક, કોઈ જગ્યાએ",
        "ક્યાંથી, જ્યાં, ક્યાં ",
        "ક્યારે, જ્યારે",
        "ક્યારેક ક્યારેક",
        "ઘણું બધું",
        "ઘણું, પુસ્કળ, અતિશય",
        "જેથી",
        "જેને, જેમને",
        "જેમ",
        "જેમ કે, જેમ, જે રીતે, જેવા કે",
        "જો",
        "તને",
        "તમારા, તમારું",
        "તમારું",
        "તમે, તું",
        "તારું",
        "તે જેવી, તેની જેમ",
        "તે રીતે, તે તરફ",
        "તેઓ",
        "તેઓનું",
        "તેઓને, તેમને",
        "તેણીના",
        "તેથી, તો",
        "તેના",
        "તેનું, તેના",
        "તેમના, તેમનું, તેઓની",
        "તેમને. એમને",
        "તેવું",
        "ત્યાં",
        "ત્યાં સુધી",
        "થોડા",
        "થોડું",
        "દરેક",
        "દૂર",
        "દ્વારા",
        "નજીક, પાસે",
        "ના, નહિ",
        "ના, નો",
        "ની અંદર",
        "ની સામે",
        "નીચે",
        "પછી",
        "પછી, ત્યારે",
        "પછીથી",
        "પણ",
        "પરંતુ, પણ",
        "પાછળ",
        "પેલી",
        "પેલું",
        "પેલો, તે",
        "પ્રતિ",
        "ફરીથી, ફરી",
        "બંને, બેઉ",
        "બધા",
        "બહાર",
        "બાજુમાં",
        "ભરપૂર",
        "મને",
        "માં",
        "માંથી, થી",
        "માટે",
        "માથે, ઉપર",
        "મારા",
        "મારુ, મારી ",
        "મારું",
        "લીધે, કારણ કે,કેમ કે",
        "વધારાનું",
        "વધારે",
        "વધારે, વધુ ",
        "શું",
        "સમગ્ર",
        "સમાન, એક સરખું",
        "સાથે",
        "સિવાય",
        "સુધી",
        "સૌથી વધુ",
        "હજુ સુધી",
        "હું",
    ],
    "hi": [
        "अंदर",
        "अकेला",
        "अतिरिक्त",
        "अथवा, या",
        "अधिकांश",
        "अन्यथा",
        "अब, अभि, इसी वक्त",
        "अभी तक",
        "आधा",
        "आप, तुम, तुजे",
        "आपका, तुम्हारा, तेरा",
        "इधर, यहाँ",
        "इन्हें, इन",
        "इस तरफ",
        "इस से",
        "इसका, इसकी",
        "इसके द्वारा",
        "इसके साथ",
        "इसलिए",
        "इसलिए, तो",
        "उदाहरण के लिए",
        "उन को, इन को, उन्हें, इन्हें",
        "उनका, उनके, उनकी, इनका",
        "उनके",
        "उनमें से",
        "उन्हें",
        "उस तरफ, उसी और",
        "उसकी, उसके",
        "उसके जैसा",
        "उसको, उसके, इसको, इसके, इसकी",
        "ऊपर",
        "ऐसा",
        "और",
        "कब, जब",
        "कभी - कभी",
        "कभी कभी",
        "कम",
        "कम, थोड़ा",
        "कहीं",
        "का, की, के",
        "काफ़ी",
        "किंतु, पर, लेकिन, मगर",
        "कितने",
        "किस तरफ",
        "किसके, जिसके, जिनके, किसका",
        "किसको, किसे, जिसे, जिन्हे",
        "किसी को",
        "की ओर, की तरफ़",
        "कुछ, थोड़े",
        "के अंदर",
        "के अलावा",
        "के ऊपर",
        "के लिये",
        "के सामने",
        "कैसे, कैसा",
        "कोई",
        "कोई न कोई",
        "कोई नहीं",
        "कोई, कोई व्यक्ति",
        "कौन",
        "कौन सा, जो",
        "कौन, जो",
        "क्या",
        "क्यों",
        "क्योंकि, चूंकि",
        "जब तक",
        "जब तक, तक तक",
        "जहाँ, कहां, किधर",
        "जिसका",
        "जैसा",
        "जैसे",
        "जैसे की, जैसा, वैसा",
        "जैसे, इस तरह",
        "ज्यादा, अधिक",
        "ढेर सारा",
        "ढेर सारा, बहुत सारा",
        "तक",
        "तक, जब तक",
        "तब, फिर",
        "ताकि",
        "तुम्हारा",
        "तुम्हारा, तुम्हारे",
        "तुम्हे, तुझे, तुमको",
        "तेरा, तेरी",
        "थोड़ा",
        "दाहिने, दाहिना",
        "दुसरा, एक और",
        "दूर",
        "दोनों",
        "द्वारा",
        "नहीं, मत ",
        "नीचे",
        "पास में, पास",
        "पास, नजदीक, करीब",
        "पीछे",
        "पूरा",
        "प्रति, से, तक",
        "प्रत्येक",
        "फिर, तो, तब, उस वक़्त",
        "फिर, दुबारा",
        "बजाय",
        "बहुत, अनेक",
        "बहुत, ज्यादा, काफी",
        "बाएं, वाम",
        "बाद में",
        "बाद में, पीछे",
        "बाहर",
        "भी",
        "मुझे",
        "में, भीतर, अंदर",
        "में, मैंने",
        "मेरा, अपना",
        "मेरा, मेरी",
        "मेरी, मेरा, मेरे",
        "यदि",
        "यदि, अगर",
        "यदि, या",
        "यह, ये, इसे",
        "लेकिन",
        "वह",
        "वह, जो",
        "वहां",
        "वही",
        "वे, वह, वो, उन्होंने",
        "वैसे, उसके जैसा",
        "शायद",
        "सब लोग",
        "सब, सभी, सारे",
        "सबसे ज्यादा, अधिकांश",
        "साथ",
        "से",
        "हम",
        "हमारा, हमारे, हमारी",
        "हर जगह",
        "हालाँकि",
    ],
    "id": [
        "Anda",
        "ada",
        "adakah",
        "adalah",
        "adanya",
        "adapaun",
        "adapun",
        "agar",
        "akan",
        "akau",
        "akhirnya",
        "akibat",
        "akibatnya",
        "aku",
        "alias",
        "anda",
        "aneka",
        "antar",
        "antara",
        "antaranya",
        "apa",
        "apabila",
        "apakah",
        "apalagi",
        "apapun",
        "asal",
        "atas",
        "atau",
        "ataukah",
        "ataupun",
        "bagai",
        "bagaimana",
        "bagaimanakah",
        "bagaimanapun",
        "bagi",
        "bagi-nya",
        "bahkan",
        "bahwa",
        "bahwasanya",
        "baik",
        "bakal",
        "balik",
        "banyak",
        "banyaknya",
        "baru",
        "bawah",
        "beberapa",
        "begini",
        "beginilah",
        "begitu",
        "belakang",
        "beliau",
        "belum",
        "beragam",
        "berapa",
        "berapakah",
        "berbagai",
        "berberapa",
        "berdasar",
        "berdasarkan",
        "berdiri",
        "berdirinya",
        "berikut",
        "berkat",
        "bersama",
        "bersamanya",
        "berupa",
        "beserta",
        "betapa",
        "bila",
        "bilamana",
        "bisa",
        "boleh",
        "buah",
        "buat",
        "bukan",
        "bukankah",
        "bukanlah",
        "bukannya",
        "buruh",
        "cara",
        "dalam",
        "dalamnya",
        "dan",
        "dapat",
        "dari",
        "darimana",
        "daripada",
        "dekat",
        "demi",
        "demikian",
        "dengan",
        "dengannya",
        "depan",
        "dg",
        "di",
        "dia",
        "diantara",
        "diantaranya",
        "diatas",
        "dibalik",
        "dibandingkan",
        "dibawah",
        "dibawahnya",
        "dibeberapa",
        "dibelakang",
        "diberbagai",
        "didalam",
        "didalamnya",
        "diluar",
        "dimana",
        "diri",
        "dirinya",
        "disaat",
        "disamping",
        "disebelah",
        "disekeliling",
        "diseluruh",
        "disini",
        "ditepi",
        "dng",
        "dr",
        "engkau",
        "gambar",
        "gimana",
        "hadap",
        "hai",
        "hanya",
        "harus",
        "hei",
        "ia",
        "ialah",
        "ini",
        "inikah",
        "inilah",
        "inipun",
        "isi",
        "isinya",
        "itu",
        "itua",
        "itulah",
        "itupun",
        "iye",
        "jadi",
        "jangan",
        "jauh",
        "jelang",
        "jenis",
        "jika",
        "juga",
        "kah",
        "kalau",
        "kalian",
        "kalo",
        "kami",
        "kamilah",
        "kamu",
        "kan",
        "kapan",
        "kapankah",
        "karena",
        "karenanya",
        "kau",
        "ke",
        "kebanyakan",
        "kecuali",
        "kedalam",
        "kedepan",
        "kedua",
        "keduanya",
        "keliling",
        "keluar",
        "kemudian",
        "kena",
        "kenapa",
        "kendati",
        "kepada",
        "kepadaku",
        "kepadamu",
        "kepadanya",
        "kepusatnya",
        "kerana",
        "keseluruhan",
        "keseluruhannya",
        "kesemuanya",
        "ketika",
        "ketimbang",
        "khususnya",
        "kira",
        "kita",
        "kok",
        "koq",
        "kpd",
        "ku",
        "la",
        "lagi",
        "lah",
        "lain",
        "lainnya",
        "lalu",
        "lama",
        "lantaran",
        "lantas",
        "layak",
        "layaknya",
        "lengah",
        "lewat",
        "loh",
        "luar",
        "macam",
        "maka",
        "makanya",
        "maksud",
        "maksudnya",
        "malahan",
        "mampu",
        "mana",
        "manakah",
        "manakala",
        "manapun",
        "masa",
        "masing",
        "masing-masing",
        "maupun",
        "mayoritas",
        "melainkan",
        "melalui",
        "melawan",
        "melewati",
        "menajak",
        "menbeli",
        "mengajak",
        "mengapa",
        "mengenai",
        "mengenainya",
        "menjadi",
        "menjelang",
        "menuju",
        "menurut",
        "menurutmu",
        "mereka",
        "merekapun",
        "merupakan",
        "meski",
        "meskipn",
        "meskipun",
        "misalkan",
        "misalnya",
        "msl",
        "mulai",
        "mungkin",
        "namun",
        "nya",
        "oleh",
        "olehnya",
        "orang",
        "pada",
        "padahal",
        "padanya",
        "para",
        "pasca",
        "pd",
        "per",
        "perihal",
        "perlu",
        "pula",
        "pun",
        "saat",
        "saatnya",
        "sama",
        "sambil",
        "sampai",
        "sampai-sampai",
        "samping",
        "sana",
        "sang",
        "satu",
        "satu-satunya",
        "satunya",
        "saya",
        "seakan",
        "seandainya",
        "seantero",
        "sebab",
        "sebagai",
        "sebagaimana",
        "sebagian",
        "sebaliknya",
        "sebangsa",
        "sebanyak",
        "sebelah",
        "sebelum",
        "sebelumnya",
        "seberang",
        "seberat",
        "sebesar",
        "sebuah",
        "secara",
        "sedang",
        "sedangkan",
        "sedangkkan",
        "sedari",
        "sedikit",
        "sedikitnya",
        "seekor",
        "segala",
        "segenap",
        "seharusnya",
        "sehingga",
        "sehubungan",
        "seiring",
        "sejak",
        "sejauh",
        "sejenis",
        "sejumlah",
        "sekali",
        "sekaligus",
        "sekalipun",
        "sekitar",
        "sekitarnya",
        "selain",
        "selaku",
        "selama",
        "selesai",
        "seluas",
        "seluruh",
        "semacam",
        "semasa",
        "semenjak",
        "sementara",
        "sempat",
        "semua",
        "semuanya",
        "sendiri",
        "senilai",
        "seorang",
        "sepanjang",
        "sepasang",
        "sepeninggal",
        "seperti",
        "sepertinya",
        "sepeti",
        "sepucuk",
        "seputar",
        "serangkaian",
        "seraya",
        "serta",
        "sesampai",
        "sesampainya",
        "seseorang",
        "sesuai",
        "sesuatu",
        "sesudah",
        "setebal",
        "setelah",
        "setelahnya",
        "setengah",
        "setiap",
        "setinggi",
        "seusai",
        "sewaktu",
        "si",
        "siapa",
        "siapakah",
        "siapapun",
        "silakan",
        "sini",
        "sinilah",
        "situ",
        "soal",
        "suatu",
        "sudah",
        "supaya",
        "tak",
        "tan",
        "tangguh",
        "tanpa",
        "tapi",
        "tatkala",
        "telah",
        "tempat",
        "tengah",
        "tengahnya",
        "tentang",
        "tepat",
        "tepatnya",
        "teratas",
        "terhadap",
        "terhadapnya",
        "termasuk",
        "ternyata",
        "tersebut",
        "tertentu",
        "terutama",
        "tesebut",
        "tetap",
        "tetapi",
        "tiada",
        "tiap",
        "tidak",
        "tidakkah",
        "tidaklah",
        "tidaknya",
        "tsb",
        "tt",
        "ttg",
        "tuh",
        "tujuh",
        "untuk",
        "untukmu",
        "untuknya",
        "untung",
        "usah",
        "usai",
        "via",
        "waktu",
        "walau",
        "walaupun",
        "ya",
        "yaitu",
        "yakni",
        "yang",
        "yg",
    ],
    "mr": [
        "अधिक",
        "अनेक",
        "अशी",
        "असलयाचे",
        "असलेल्या",
        "असा",
        "असून",
        "असे",
        "आज",
        "आणि",
        "आता",
        "आपल्या",
        "आला",
        "आली",
        "आले",
        "आहे",
        "आहेत",
        "एक",
        "एका",
        "कमी",
        "करणयात",
        "करून",
        "का",
        "काम",
        "काय",
        "काही",
        "किवा",
        "की",
        "केला",
        "केली",
        "केले",
        "कोटी",
        "गेल्या",
        "घेऊन",
        "जात",
        "झाला",
        "झाली",
        "झाले",
        "झालेल्या",
        "टा",
        "डॉ",
        "तर",
        "तरी",
        "तसेच",
        "ता",
        "ती",
        "तीन",
        "ते",
        "तो",
        "त्या",
        "त्याचा",
        "त्याची",
        "त्याच्या",
        "त्याना",
        "त्यानी",
        "त्यामुळे",
        "त्री",
        "दिली",
        "दोन",
        "न",
        "नाही",
        "निर्ण्य",
        "पण",
        "पम",
        "परयतन",
        "पाटील",
        "म",
        "मात्र",
        "माहिती",
        "मी",
        "मुबी",
        "म्हणजे",
        "म्हणाले",
        "म्हणून",
        "या",
        "याचा",
        "याची",
        "याच्या",
        "याना",
        "यानी",
        "येणार",
        "येत",
        "येथील",
        "येथे",
        "लाख",
        "व",
        "व्यकत",
        "सर्व",
        "सागित्ले",
        "सुरू",
        "हजार",
        "हा",
        "ही",
        "हे",
        "होणार",
        "होत",
        "होता",
        "होती",
        "होते",
    ],
    "pt": [
        "a",
        "a cabo de",
        "a caminho de",
        "a despeito de",
        "a favor de",
        "a fim de",
        "a menos que",
        "a não ser",
        "a não ser que",
        "a partir de",
        "a propósito",
        "a respeito de",
        "a título de",
        "abaixo de",
        "acima",
        "acima de",
        "afinal",
        "afora",
        "agora",
        "agora que",
        "ai",
        "ainda",
        "ainda mais",
        "algo",
        "algum",
        "alguma",
        "algumas",
        "alguns",
        "alguém",
        "além",
        "além de",
        "ambas",
        "ambos",
        "andar",
        "andou",
        "ante",
        "antes",
        "anti",
        "antre",
        "ao",
        "ao cabo de",
        "ao invés de",
        "ao lado",
        "ao longo de",
        "ao passo que",
        "ao redor de",
        "aos cuidados de",
        "apenas",
        "apesar de",
        "apesar de que",
        "após",
        "aquela",
        "aquelas",
        "aquele",
        "aqueles",
        "aquilo",
        "as",
        "assim",
        "assim como",
        "assim que",
        "atras",
        "através",
        "através de",
        "atráis",
        "atrás",
        "atrás de",
        "até",
        "até que",
        "auto",
        "avante",
        "aí",
        "bastante",
        "bem",
        "bem como",
        "cada",
        "cara a cara",
        "caso",
        "cerca",
        "cima",
        "com",
        "comigo",
        "como",
        "como se",
        "conforme",
        "connosco",
        "conosco",
        "conquanto",
        "consigo",
        "consoante",
        "contanto",
        "contanto que",
        "contigo",
        "contra",
        "contudo",
        "convosco",
        "cuja",
        "cujas",
        "cujo",
        "cujos",
        "d'",
        "d.",
        "da",
        "dada",
        "dado",
        "dado que",
        "dali",
        "daquela",
        "daquelas",
        "daquele",
        "daqui",
        "daqui a",
        "daí",
        "de",
        "de modo que",
        "dela",
        "delas",
        "dele",
        "deles",
        "demais",
        "dentre",
        "dentro",
        "dentro de",
        "depois",
        "depois de",
        "desde",
        "desde que",
        "dessa",
        "dessas",
        "desse",
        "desses",
        "desta",
        "destas",
        "deste",
        "destes",
        "detrás de",
        "deva",
        "devam",
        "deve",
        "devem",
        "devemos",
        "devendo",
        "dever",
        "deveria",
        "deveriam",
        "deverá",
        "deverão",
        "deviam",
        "devido",
        "devido a",
        "devo",
        "diante de",
        "disso",
        "diversas",
        "diversos",
        "do que",
        "donde",
        "doutros",
        "dum",
        "duma",
        "durante",
        "e",
        "e/ou",
        "eba",
        "eis",
        "ela",
        "elas",
        "ele",
        "eles",
        "eles/elas",
        "em",
        "em cima de",
        "em frente a",
        "em meio a",
        "em nome de",
        "em prol de",
        "em relação a",
        "em torno de",
        "em vez de",
        "em virtude de",
        "em vista de",
        "em volta de",
        "embaixo de",
        "embora",
        "enquanto",
        "entre",
        "entretanto",
        "então",
        "era",
        "eram",
        "ergo",
        "essa",
        "essas",
        "esse",
        "esses",
        "esta",
        "estado",
        "estamos",
        "estando",
        "estar",
        "estarem",
        "estaria",
        "estariam",
        "estarmos",
        "estará",
        "estarão",
        "estas",
        "estava",
        "estavam",
        "este",
        "esteja",
        "estejam",
        "estes",
        "esteve",
        "estivemos",
        "estiver",
        "estiveram",
        "estiverem",
        "estivesse",
        "estivessem",
        "estou",
        "está",
        "estávamos",
        "estão",
        "eu",
        "excepto",
        "exceto",
        "fica",
        "ficado",
        "ficamos",
        "ficando",
        "ficar",
        "ficaram",
        "ficaria",
        "ficou",
        "fiquei",
        "foi",
        "fomos",
        "for",
        "fora",
        "fora de",
        "foram",
        "forem",
        "fosse",
        "fossem",
        "frente a",
        "fui",
        "fôr",
        "gente",
        "graças",
        "graças a",
        "havendo",
        "haver",
        "haverem",
        "havia",
        "haviam",
        "houver",
        "houvesse",
        "há",
        "i.e.",
        "ia",
        "iam",
        "ido",
        "igual a",
        "inté",
        "invés de",
        "ir",
        "ireii",
        "irem",
        "iremos",
        "iria",
        "iriam",
        "irá",
        "irão",
        "isso",
        "isto",
        "junto a",
        "junto com",
        "já",
        "já que",
        "la",
        "las",
        "lhe",
        "lhes",
        "lo",
        "logo",
        "logo que",
        "los",
        "lá",
        "mais",
        "mais de",
        "mais do que",
        "mais que",
        "mal",
        "malgrado",
        "mas",
        "me",
        "mediante",
        "menos",
        "mesma",
        "mesmas",
        "mesmo",
        "mesmo que",
        "mesmo se",
        "mesmos",
        "meu",
        "meus",
        "mim",
        "minha",
        "minhas",
        "muita",
        "muitas",
        "muito",
        "muito menos",
        "muitos",
        "muitíssimo",
        "n'",
        "na",
        "na frente de",
        "na sequência de",
        "nada",
        "naquela",
        "naquele",
        "naqueles",
        "naquilo",
        "nas",
        "nele",
        "neles",
        "nem",
        "nenhum",
        "nenhuma",
        "nenhumas",
        "nenhuns",
        "nessa",
        "nessas",
        "nesse",
        "nesses",
        "nesta",
        "nestas",
        "neste",
        "nestes",
        "ninguém",
        "no",
        "no que",
        "nos",
        "nosco",
        "nossa",
        "nossas",
        "nosso",
        "nossos",
        "num",
        "numa",
        "nós",
        "o",
        "o(s)",
        "onde",
        "onde quer que",
        "ora",
        "os",
        "ou",
        "outra",
        "outras",
        "outrem",
        "outro",
        "outros",
        "outrém",
        "oxalá",
        "p'ra",
        "p/",
        "pa",
        "para",
        "para com",
        "para que",
        "parece",
        "parecer",
        "pelo",
        "per",
        "perante",
        "perantes",
        "permanece",
        "permanecer",
        "perto de",
        "pode",
        "podem",
        "podemos",
        "podendo",
        "poder",
        "poderei",
        "poderem",
        "poderemos",
        "poderia",
        "poderiam",
        "poderá",
        "poderão",
        "poderíamos",
        "podia",
        "podiam",
        "podíamos",
        "pois",
        "por",
        "por causa de",
        "por causa que",
        "por conta de",
        "por entre",
        "por isso",
        "por isto",
        "por meio de",
        "por trás",
        "por trás de",
        "por volta de",
        "porquanto",
        "porque",
        "portanto",
        "porém",
        "possa",
        "possam",
        "possamos",
        "posso",
        "pouca",
        "poucas",
        "pouco",
        "poucos",
        "pouquíssimos",
        "pra",
        "precisam",
        "precisar",
        "precisaram",
        "precisarão",
        "precisou",
        "prestes a",
        "pretender",
        "pretendiam",
        "pro",
        "pré",
        "pré-",
        "pró",
        "pude",
        "pudemos",
        "puderam",
        "puderem",
        "pudesse",
        "pudessem",
        "pós",
        "pôde",
        "pôr",
        "público",
        "q.b.",
        "quais",
        "quaisquer",
        "qual",
        "qualquer",
        "quando",
        "quanta",
        "quantas",
        "quanto",
        "quanto a",
        "quanto baste",
        "quanto mais",
        "quantos",
        "que",
        "quem",
        "quer",
        "quão",
        "quê",
        "rente a",
        "rente de",
        "rumo a",
        "se",
        "se bem que",
        "se e somente se",
        "se-",
        "segundo",
        "seja",
        "sejam",
        "sem",
        "sem falar de",
        "sempre que",
        "sendo",
        "sendo que",
        "senão",
        "ser",
        "serei",
        "serem",
        "seremos",
        "seria",
        "seriam",
        "sermos",
        "será",
        "serão",
        "seu",
        "seus",
        "si",
        "sido",
        "sob",
        "sobre",
        "somos",
        "sou",
        "sse",
        "sua",
        "suas",
        "sub",
        "são",
        "sê",
        "só que",
        "sôbre",
        "ta",
        "tais",
        "tal",
        "tampouco",
        "tanta",
        "tantas",
        "tanto",
        "tantos",
        "te",
        "tem",
        "temos",
        "tende",
        "tendo",
        "tenha",
        "tenham",
        "tenhamos",
        "tenho",
        "tentado",
        "tentar",
        "tentaram",
        "ter",
        "terei",
        "terem",
        "teremos",
        "teria",
        "teriam",
        "termos",
        "terá",
        "terão",
        "teríamos",
        "teu",
        "teus",
        "teve",
        "ti",
        "tido",
        "tinha",
        "tinham",
        "tive",
        "tivemos",
        "tiver",
        "tiveram",
        "tiverem",
        "tivesse",
        "tivessem",
        "to",
        "toda",
        "todas",
        "todavia",
        "todo",
        "todos",
        "trás",
        "tu",
        "tua",
        "tuas",
        "tudo",
        "tá",
        "tão",
        "tão logo",
        "té",
        "têm",
        "tínhamos",
        "ultra",
        "um",
        "uma",
        "uma vez que",
        "umas",
        "uns",
        "vai",
        "vais",
        "vamos",
        "varias",
        "varios",
        "versus",
        "via",
        "visto",
        "visto que",
        "voce",
        "você",
        "vocês",
        "vos",
        "vossa",
        "vossas",
        "vosso",
        "vossos",
        "vou",
        "vs",
        "vá",
        "várias",
        "vários",
        "vão",
        "vérsus",
        "vós",
        "à",
        "à beira de",
        "à custa de",
        "à expensa de",
        "à luz de",
        "à medida que",
        "àquela",
        "àqueles",
        "às",
        "às custas de",
        "às expensas de",
        "é",
        "íamos",
        "\u200b\u200bem",
    ],
    "sw": [
        "akasema",
        "alikuwa",
        "alisema",
        "baada",
        "basi",
        "bila",
        "cha",
        "chini",
        "hadi",
        "hapo",
        "hata",
        "hivyo",
        "hiyo",
        "huku",
        "huo",
        "ili",
        "ilikuwa",
        "juu",
        "kama",
        "karibu",
        "katika",
        "kila",
        "kima",
        "kisha",
        "kubwa",
        "kutoka",
        "kuwa",
        "kwa",
        "kwamba",
        "kwenda",
        "kwenye",
        "la",
        "lakini",
        "mara",
        "mdogo",
        "mimi",
        "mkubwa",
        "mmoja",
        "moja",
        "muda",
        "mwenye",
        "na",
        "naye",
        "ndani",
        "ng",
        "ni",
        "nini",
        "nonkungu",
        "pamoja",
        "pia",
        "sana",
        "sasa",
        "sauti",
        "tafadhali",
        "tena",
        "tu",
        "vile",
        "wa",
        "wakati",
        "wake",
        "walikuwa",
        "wao",
        "watu",
        "wengine",
        "wote",
        "ya",
        "yake",
        "yangu",
        "yao",
        "yeye",
        "yule",
        "za",
        "zaidi",
        "zake",
    ],
    "ur": [
        "اسلئے",
        "اسکے جیسا",
        "ان کے بیچ ,ان لوگوں کے بیچ",
        "اندر",
        "انکا",
        "اور ,و",
        "اوپر",
        "اگر ,گرچہ ,اگرچہ",
        "باہر",
        "بایاں ,بائیں",
        "بجائے ,بدلے ,بدلے میں",
        "بہت ,بہت سارے ,بہت کچھ",
        "بہت زیادہ",
        "تب تک",
        "تم لوگ ,آپ ,آپ لوگ",
        "تمہارا ,تیرا ,آپکا",
        "تو, تم ,آپ",
        "تھوڑا ,تھوڑی",
        "جب تک",
        "جسکا",
        "جیسے",
        "حالاںکہ",
        "دایاں ,دائیں ,صحیح",
        "دوسرا",
        "زیادہ تر",
        "ساتھ ,کے ساتھ",
        "سب ,سبھی ,سب کچھ ,سارے ,سارا",
        "سب لوگ",
        "طرف ,اسکی طرف",
        "لیکن",
        "مثلأ ,مثال کے طور پے",
        "میرا",
        "میں",
        "میں ,کے اندر ,اندر",
        "نہی تو",
        "نہیں ,ناں ,نا",
        "نیچے",
        "وہ ,وہ لوگ",
        "وہ ,وہ والا, کہ",
        "وہ ,یے",
        "وہاں",
        "پھر",
        "پہ ,پر ,میں",
        "کافی",
        "کب",
        "کبھی کبھی",
        "کم",
        "کوئی",
        "کون",
        "کونسا",
        "کچھ",
        "کہاں",
        "کیا",
        "کیسے",
        "کیوںکہ ,چوںکہ ,کیوںکی",
        "کےلئے",
        "ہم ,ھم",
        "یہ ,یہ والا",
        "یہاں",
    ],
    "vi": [
        "ai",
        "ai ai",
        "ai nấy",
        "anh",
        "anh em",
        "anh trai",
        "anh ấy",
        "ba",
        "bao",
        "bao giờ",
        "bay",
        "bà",
        "bà con",
        "bà ấy",
        "bác",
        "bây",
        "bé",
        "bên",
        "bạn",
        "bạn gái",
        "bạn trai",
        "bả",
        "bản thân",
        "bất chấp",
        "bất cứ",
        "bất kì",
        "bất luận",
        "bất nhược",
        "bất quá",
        "bấy",
        "bấy nhiêu",
        "bần tăng",
        "bầy quân",
        "bầy tui",
        "bậu",
        "bằng",
        "bệ hạ",
        "bị cáo",
        "bố",
        "bố nó",
        "bồ",
        "bộ",
        "bởi",
        "bởi vì",
        "cc",
        "cha",
        "chao",
        "chi",
        "chiếu theo",
        "cho",
        "cho dù",
        "cho đến",
        "choa",
        "chàng",
        "chán",
        "cháu",
        "chí",
        "chính",
        "chú",
        "chú mày",
        "chúng",
        "chúng mày",
        "chúng mình",
        "chúng nó",
        "chúng ta",
        "chúng tao",
        "chúng tôi",
        "chút",
        "chăng",
        "chưa",
        "chưng",
        "chả",
        "chắc",
        "chẳng cứ",
        "chỉ",
        "chị",
        "chị gái",
        "chị ấy",
        "chớ",
        "chứ",
        "con",
        "con này",
        "cuối cùng",
        "các",
        "các hạ",
        "cái",
        "cái gì",
        "cái này",
        "cán bộ",
        "còn",
        "có",
        "có vẻ",
        "cóc",
        "cô",
        "cô nương",
        "cô ta",
        "cô ấy",
        "côi",
        "công tử",
        "cùng",
        "cơ",
        "cơ mà",
        "cưng",
        "cạnh",
        "cả",
        "cả nhà",
        "cầm bằng",
        "cậu",
        "cổ",
        "cộng",
        "cụ",
        "của",
        "cứ",
        "do",
        "do vậy",
        "do đó",
        "duy",
        "dù",
        "dù sao",
        "dù vậy",
        "dưng",
        "dưới",
        "dường như",
        "dạ",
        "dầu",
        "dẫu",
        "dẫu vậy",
        "dậy",
        "dọc",
        "dợ",
        "em",
        "ghe",
        "già",
        "giá như",
        "giả dụ",
        "giả sử",
        "giữa",
        "gì",
        "ha",
        "hay",
        "hay là",
        "hen",
        "hoàng thượng",
        "hoặc",
        "huynh",
        "huống",
        "huống chi",
        "huống gì",
        "huống hồ",
        "há",
        "hôn",
        "hơn",
        "hơn nữa",
        "hả",
        "hầu hết",
        "hắn",
        "hết",
        "hết cả",
        "hề",
        "hễ",
        "họ",
        "hổi",
        "hỡi",
        "hử",
        "khanh",
        "khi",
        "khi nào",
        "không",
        "không ai",
        "không những",
        "khứa",
        "kia",
        "kém",
        "kìa",
        "kẻo",
        "kể từ",
        "l",
        "là",
        "lão",
        "lên",
        "lại nữa",
        "lần",
        "lẫn",
        "lắm",
        "mi",
        "min",
        "miễn",
        "moa",
        "muôn",
        "muội",
        "mà",
        "mà còn",
        "mày",
        "mãi",
        "mình",
        "mô",
        "mũ",
        "mất",
        "mấy",
        "mầy",
        "mẫu hậu",
        "mặc dù",
        "mặc dầu",
        "mặt khác",
        "mẹ",
        "mẹ nó",
        "mọi",
        "mọi người",
        "mọi vật",
        "mỏa",
        "mỗi",
        "một chút",
        "một nửa",
        "một số",
        "một vài",
        "một ít",
        "mụ",
        "ngay",
        "nghe",
        "nghen",
        "nghỉ",
        "ngoài",
        "ngoài ra",
        "ngoại",
        "ngoải",
        "ngài",
        "ngươi",
        "người",
        "người người",
        "người ta",
        "ngược lại",
        "ngộ",
        "nha",
        "nhiều",
        "nhà quân",
        "nhá",
        "nhân",
        "nhân dịp",
        "nhé",
        "như",
        "như vậy",
        "nhưng",
        "nhưng mà",
        "nhược bằng",
        "nhất là",
        "nhằm",
        "nhỉ",
        "nhỏ",
        "nhờ",
        "nhỡ",
        "những",
        "ni",
        "nà",
        "nàng",
        "nào",
        "này",
        "nè",
        "nên",
        "nó",
        "nô tài",
        "nô tì",
        "nơi",
        "nơi nơi",
        "nấy",
        "nầy",
        "nẩu",
        "nếu",
        "nếu như",
        "nọ",
        "nội",
        "nớ",
        "nừng",
        "nửa",
        "nữa",
        "phi",
        "phía",
        "phô bay",
        "phải",
        "phải hôn",
        "phải không",
        "phần",
        "phần lớn",
        "phỏng",
        "phứt",
        "qua",
        "quanh",
        "quý khách",
        "quý vị",
        "quả",
        "quả nhân",
        "ra",
        "riêng",
        "rùi",
        "rằng",
        "rồi",
        "sang",
        "sao",
        "sau",
        "sau cùng",
        "song",
        "song le",
        "sắp",
        "sẽ",
        "sở dĩ",
        "ta",
        "tao",
        "tau",
        "thanh niên",
        "thay",
        "thay vì",
        "theo",
        "theo đó",
        "thiếp",
        "thiệt",
        "thành",
        "thâu",
        "thêm",
        "thì",
        "thí dụ",
        "thôi",
        "thần",
        "thầy",
        "thẩy",
        "thật",
        "thằng này",
        "thế",
        "thế là",
        "thế mà",
        "thế nhưng",
        "thị",
        "thời",
        "tiểu nhân",
        "toa",
        "toà",
        "toàn",
        "toàn bộ",
        "toàn thể",
        "trong",
        "trong khi",
        "trong đó",
        "trái",
        "trái lại",
        "trên",
        "trò",
        "trước",
        "trẫm",
        "trời",
        "trừ phi",
        "tuy",
        "tuy nhiên",
        "tuy rằng",
        "tuy vậy",
        "tê",
        "tóm lại",
        "tôi",
        "tương đương",
        "tại",
        "tại hạ",
        "tại vì",
        "tất cả",
        "tầm",
        "tận",
        "tỉ",
        "tổ",
        "tớ",
        "tới",
        "tụi",
        "tụi nó",
        "tức",
        "tức là",
        "từ",
        "tự",
        "tựa",
        "ui",
        "và",
        "vài",
        "vài ba",
        "vào",
        "vì",
        "vì thế",
        "vì vậy",
        "ví dụ",
        "ví như",
        "vô",
        "vô số",
        "vô vàn",
        "vả chăng",
        "vả lại",
        "vậy",
        "vậy là",
        "vậy mà",
        "về",
        "về hướng",
        "về phía",
        "vị",
        "với",
        "xuống",
        "à",
        "á",
        "ái khanh",
        "âu là",
        "í",
        "ít",
        "ông",
        "ông ấy",
        "út",
        "ý",
        "đa số",
        "đang",
        "đi",
        "đâu",
        "đây",
        "đã",
        "đê",
        "đích thân",
        "đó",
        "đôi",
        "đương",
        "được",
        "đại nhân",
        "đấy",
        "đầu tiên",
        "đằng này",
        "đằng ấy",
        "đẳng",
        "đặng",
        "đến",
        "để",
        "đệ",
        "đối với",
        "đồ",
        "ơi",
        "ư",
        "ạ",
        "ả",
        "ảnh",
        "ấy",
        "ẻm",
        "ổng",
        "ờ",
        "ở",
        "ừ",
        "ừa",
        "ừm",
    ],
    "yo": [
        "a",
        "an",
        "bá",
        "bí",
        "bẹ̀rẹ̀",
        "fún",
        "fẹ́",
        "gbogbo",
        "inú",
        "jù",
        "jẹ",
        "jẹ́",
        "kan",
        "kì",
        "kí",
        "kò",
        "láti",
        "lè",
        "lọ",
        "mi",
        "mo",
        "máa",
        "mọ̀",
        "ni",
        "náà",
        "ní",
        "nígbà",
        "nítorí",
        "nǹkan",
        "o",
        "padà",
        "pé",
        "púpọ̀",
        "pẹ̀lú",
        "rẹ̀",
        "sì",
        "sí",
        "sínú",
        "ṣ",
        "ti",
        "tí",
        "wà",
        "wá",
        "wọn",
        "wọ́n",
        "yìí",
        "àti",
        "àwọn",
        "é",
        "í",
        "òun",
        "ó",
        "ń",
        "ńlá",
        "ṣe",
        "ṣé",
        "ṣùgbọ́n",
        "ẹmọ́",
        "ọjọ́",
        "ọ̀pọ̀lọpọ̀",
    ],
    "zh": [
        "",
        "一",
        "一争",
        "一些",
        "一切",
        "一旦",
        "一点",
        "一爭",
        "上",
        "上前",
        "上表",
        "下",
        "不",
        "不仅",
        "不会",
        "不但",
        "不僅",
        "不光",
        "不关",
        "不准",
        "不单",
        "不可",
        "不單",
        "不够",
        "不夠",
        "不应",
        "不得",
        "不想",
        "不愿",
        "不應",
        "不是",
        "不會",
        "不準",
        "不用",
        "不管",
        "不經",
        "不肯",
        "不能",
        "不要",
        "不該",
        "不論",
        "不论",
        "不该",
        "不過",
        "不需",
        "不願",
        "与",
        "与其",
        "且",
        "且是",
        "並",
        "並且",
        "並非",
        "个",
        "个人",
        "中",
        "临",
        "为",
        "为了",
        "为人",
        "为什么",
        "主",
        "乃至",
        "之",
        "之上",
        "之下",
        "之中",
        "之內",
        "之内",
        "之初",
        "之前",
        "之后",
        "之外",
        "之後",
        "之所以",
        "之时",
        "之時",
        "之間",
        "之间",
        "也",
        "也是",
        "书",
        "了",
        "争辩",
        "事",
        "于",
        "井",
        "亚",
        "亞",
        "亦为",
        "亦是",
        "亦為",
        "亭",
        "亲",
        "人",
        "人人",
        "人家",
        "什么",
        "什麼",
        "今",
        "仍是",
        "仍算",
        "从",
        "他",
        "他们",
        "他俩",
        "他倆",
        "他們",
        "代",
        "令",
        "以",
        "以上",
        "以下",
        "以为",
        "以來",
        "以前",
        "以北",
        "以及",
        "以后",
        "以外",
        "以往",
        "以後",
        "以来",
        "以為",
        "以爲",
        "以至",
        "们",
        "价",
        "任",
        "任何",
        "众",
        "会",
        "传",
        "伪",
        "似乎",
        "似的",
        "但",
        "但是",
        "位",
        "低",
        "住",
        "体",
        "何",
        "何方",
        "佛",
        "作",
        "作为",
        "作為",
        "你",
        "你们",
        "你們",
        "你自己",
        "你门",
        "佬",
        "併",
        "使",
        "來",
        "供",
        "依",
        "依据",
        "依據",
        "依照",
        "依靠",
        "侠",
        "侧",
        "侨",
        "侯",
        "便是",
        "係",
        "保存",
        "保級",
        "保级",
        "俠",
        "信",
        "修复",
        "修復",
        "個",
        "個人",
        "們",
        "倘若",
        "借助",
        "借由",
        "借着",
        "值",
        "假使",
        "假如",
        "偏",
        "做",
        "側",
        "偽",
        "傳",
        "傻",
        "像",
        "像是",
        "僑",
        "價",
        "儘管",
        "元",
        "先",
        "光",
        "光棍",
        "党",
        "內",
        "內外",
        "全",
        "全体",
        "全副",
        "全套",
        "全部",
        "全體",
        "公",
        "关",
        "关于",
        "关心",
        "兵",
        "其",
        "其中",
        "其他",
        "其余",
        "其它",
        "其餘",
        "典",
        "兼",
        "内",
        "内外",
        "军",
        "冠",
        "冢",
        "冲",
        "冷",
        "准",
        "准备",
        "减慢",
        "几",
        "凭",
        "凭借",
        "出手",
        "刀",
        "分",
        "分布",
        "列",
        "则为",
        "则是",
        "初",
        "別",
        "別人",
        "别",
        "别人",
        "别的",
        "到",
        "到处",
        "制",
        "券",
        "剂",
        "則是",
        "則為",
        "前",
        "前任",
        "前后",
        "前後",
        "剑",
        "剧",
        "副",
        "劇",
        "劍",
        "劑",
        "力",
        "办",
        "办学",
        "功",
        "加",
        "劣",
        "努力",
        "包",
        "包裹",
        "化",
        "区",
        "医",
        "區",
        "半",
        "单",
        "卡",
        "卫",
        "即",
        "即使",
        "即便",
        "却是",
        "卻",
        "卻是",
        "卿",
        "厂",
        "厅",
        "历届",
        "压",
        "原",
        "去",
        "县",
        "又",
        "又或",
        "又是",
        "及",
        "友",
        "发展",
        "发育",
        "变",
        "变得",
        "口",
        "古",
        "另",
        "另外",
        "只是",
        "只有",
        "只能",
        "只要",
        "可",
        "可以",
        "可是",
        "可能",
        "台",
        "史",
        "叶",
        "号",
        "司",
        "吃",
        "各",
        "各个",
        "各位",
        "各個",
        "各天",
        "各州",
        "各式",
        "各樣",
        "各种",
        "各种各样",
        "各種",
        "各種各樣",
        "各类",
        "各級",
        "各级",
        "各自",
        "各項",
        "各類",
        "各项",
        "同",
        "同年",
        "名",
        "后",
        "向",
        "吗",
        "君",
        "否",
        "吧",
        "呀",
        "员",
        "呢",
        "周",
        "味",
        "和",
        "和美",
        "咱们",
        "品",
        "哈尔滨",
        "哈爾濱",
        "員",
        "哪",
        "哪个",
        "哪些",
        "哪個",
        "哪儿",
        "哪兒",
        "哪怕",
        "哪裏",
        "哪裡",
        "哪里",
        "唯有",
        "商",
        "啊",
        "啦",
        "喇",
        "喜",
        "喜欢",
        "喜歡",
        "單",
        "單憑",
        "嗎",
        "嗬",
        "嘛",
        "嘴",
        "器",
        "回",
        "因",
        "因为",
        "因应",
        "因應",
        "因此",
        "因為",
        "团",
        "园",
        "围",
        "国",
        "图",
        "圆",
        "圈",
        "國",
        "圍",
        "園",
        "圓",
        "圖",
        "團",
        "土",
        "圣",
        "在",
        "在內",
        "在内",
        "地",
        "场",
        "坊",
        "坟",
        "坡",
        "型",
        "埋",
        "城",
        "埤",
        "執政",
        "基",
        "基于",
        "基於",
        "堂",
        "堡",
        "堤",
        "報",
        "場",
        "塔",
        "塘",
        "墓",
        "墙",
        "增長",
        "增长",
        "墟",
        "墳",
        "壓",
        "士",
        "处",
        "外",
        "多",
        "多少",
        "多次",
        "夜",
        "够",
        "夠",
        "夢",
        "大",
        "大家",
        "天",
        "头",
        "夹",
        "夾",
        "奏",
        "奖",
        "套",
        "女",
        "女士们",
        "女士门",
        "奸",
        "她",
        "她们",
        "她俩",
        "她倆",
        "她們",
        "好",
        "好了",
        "好像",
        "如",
        "如何",
        "如同",
        "如果",
        "妃",
        "妇",
        "妳",
        "妹",
        "始",
        "娘",
        "婆",
        "婦",
        "子",
        "孔",
        "字",
        "季",
        "学",
        "學",
        "宁愿",
        "它",
        "它们",
        "它們",
        "安全",
        "宏",
        "宗",
        "官",
        "实属",
        "审",
        "客",
        "室",
        "宫",
        "宮",
        "家",
        "宽",
        "富",
        "實屬",
        "審",
        "寬",
        "对",
        "对于",
        "对方",
        "对此",
        "寺",
        "将",
        "將",
        "對",
        "對方",
        "對於",
        "對此",
        "小",
        "尖",
        "就",
        "就是",
        "就算",
        "尸",
        "尽管",
        "局",
        "层",
        "屋",
        "屍",
        "展",
        "属",
        "層",
        "屬",
        "屯",
        "山",
        "屿",
        "岗",
        "岛",
        "岩",
        "岭",
        "岸",
        "峡",
        "峰",
        "島",
        "峽",
        "崖",
        "崗",
        "嶺",
        "嶼",
        "川",
        "州",
        "工",
        "左右",
        "差",
        "巷",
        "币",
        "市",
        "布",
        "师",
        "希望",
        "帝",
        "带",
        "師",
        "席",
        "帮",
        "帶",
        "帽",
        "幣",
        "幫",
        "年",
        "并",
        "并且",
        "并非",
        "幾",
        "庄",
        "床",
        "庐",
        "库",
        "应",
        "应当",
        "应该",
        "底",
        "店",
        "庙",
        "府",
        "度",
        "座",
        "庫",
        "庭",
        "廟",
        "廠",
        "廬",
        "廳",
        "廷",
        "建基於",
        "开口",
        "开始",
        "式",
        "弯",
        "張",
        "強",
        "弹",
        "强",
        "彈",
        "彎",
        "当",
        "当中",
        "当届",
        "录",
        "形",
        "形容",
        "形成",
        "影响",
        "影響",
        "彼此",
        "往",
        "径",
        "待",
        "很多",
        "後",
        "徑",
        "徒",
        "得",
        "得宠",
        "得寵",
        "從",
        "御",
        "微",
        "徽",
        "心",
        "必",
        "必須",
        "必须",
        "志",
        "快",
        "态",
        "怎么样",
        "怎樣",
        "怎麼",
        "怕",
        "性",
        "怪",
        "总",
        "恆",
        "恋",
        "恒",
        "您",
        "想",
        "愛",
        "感",
        "感到",
        "感覺",
        "感觉",
        "愿意",
        "態",
        "憑",
        "憑藉",
        "懂",
        "懂得",
        "應",
        "應當",
        "應該",
        "懒得",
        "戀",
        "戏",
        "我",
        "我们",
        "我們",
        "我自己",
        "我门",
        "或",
        "或是",
        "或者",
        "战",
        "截止",
        "截至",
        "戰",
        "戲",
        "戶",
        "户",
        "房",
        "所",
        "所以",
        "所有",
        "手",
        "才是",
        "打",
        "执政",
        "把",
        "报",
        "拖",
        "持續",
        "按",
        "按照",
        "挡",
        "损失",
        "据",
        "排行",
        "接唱",
        "接触",
        "接觸",
        "控制",
        "推进",
        "推進",
        "描述",
        "損失",
        "擋",
        "據",
        "支",
        "教",
        "敢",
        "数",
        "整",
        "整个",
        "整個",
        "整场",
        "整块",
        "整場",
        "整塊",
        "整套",
        "整所",
        "整架",
        "整片",
        "整顆",
        "整颗",
        "數",
        "文",
        "斋",
        "斗",
        "新",
        "方",
        "於",
        "族",
        "旗",
        "无论",
        "既",
        "既是",
        "既然",
        "日",
        "日趋",
        "日趨",
        "旧",
        "时",
        "星",
        "是",
        "是否",
        "是否是",
        "是次",
        "显",
        "显得",
        "時",
        "晚",
        "暖",
        "暗",
        "暨",
        "曲",
        "更为",
        "更是",
        "更為",
        "更趋",
        "更趨",
        "書",
        "替",
        "會",
        "會不會",
        "月",
        "有",
        "有些",
        "有关",
        "有的",
        "有關",
        "服",
        "朝",
        "期",
        "期間",
        "期间",
        "未能",
        "末",
        "本",
        "本人",
        "本地",
        "本屆",
        "本届",
        "本班",
        "本身",
        "术",
        "机",
        "权",
        "杆",
        "材",
        "村",
        "束",
        "来",
        "杯",
        "板",
        "林",
        "枪",
        "架",
        "某",
        "某个",
        "某些",
        "某個",
        "某种",
        "某種",
        "染色",
        "柜",
        "树",
        "校",
        "株",
        "核",
        "根据",
        "根據",
        "格",
        "案",
        "档",
        "桥",
        "桨",
        "桿",
        "梁",
        "梁耀忠",
        "梦",
        "棍",
        "棒",
        "棚",
        "椭",
        "業",
        "楼",
        "榜",
        "槍",
        "槳",
        "樂",
        "樂意",
        "樓",
        "樹",
        "橋",
        "橙",
        "機",
        "橢",
        "檔",
        "櫃",
        "權",
        "次",
        "欲",
        "款",
        "歌",
        "正",
        "正如",
        "正是",
        "此",
        "此套",
        "此次",
        "此种",
        "此種",
        "此等",
        "此类",
        "此項",
        "此類",
        "此项",
        "歷",
        "歷屆",
        "死",
        "段",
        "殿",
        "母",
        "毎年",
        "每",
        "每个",
        "每位",
        "每個",
        "每元",
        "每升",
        "每卡",
        "每周",
        "每天",
        "每幅",
        "每年",
        "每座",
        "每当",
        "每戶",
        "每户",
        "每所",
        "每日",
        "每枚",
        "每次",
        "每段",
        "每片",
        "每秒",
        "每組",
        "每组",
        "每边",
        "每週",
        "每邊",
        "每間",
        "每间",
        "每队",
        "每隊",
        "每集",
        "每首",
        "毒",
        "比",
        "比如說",
        "比起",
        "氏",
        "气",
        "氣",
        "水",
        "永保",
        "江",
        "池",
        "沒",
        "沒有",
        "沒能",
        "沟",
        "没",
        "没有",
        "没能",
        "河",
        "治军",
        "治軍",
        "沼",
        "沿",
        "沿着",
        "沿著",
        "況且",
        "泉",
        "法",
        "波",
        "洋",
        "洞",
        "洲",
        "派",
        "流沙",
        "浅",
        "浊",
        "浓",
        "浦",
        "海",
        "涉世",
        "涌",
        "液",
        "淡",
        "深",
        "深感",
        "混",
        "淺",
        "清",
        "減慢",
        "渡",
        "港",
        "湖",
        "湾",
        "準",
        "準備",
        "溝",
        "溥仪",
        "溥儀",
        "溪",
        "满",
        "满洲",
        "滩",
        "滿",
        "滿洲",
        "潮",
        "澡",
        "澳",
        "濁",
        "濃",
        "灘",
        "灣",
        "火",
        "炉",
        "炎",
        "炮",
        "点",
        "為",
        "為了",
        "為人",
        "烃",
        "烟",
        "热",
        "烴",
        "無",
        "無論",
        "煙",
        "熟",
        "熱",
        "營",
        "爐",
        "爭取",
        "爭辯",
        "爱",
        "爲",
        "父",
        "爷",
        "爺",
        "牆",
        "片",
        "版",
        "牌",
        "牠",
        "牠們",
        "物",
        "犯",
        "状",
        "狀",
        "狂",
        "狗",
        "狮",
        "猫",
        "獅",
        "獎",
        "獲利",
        "率",
        "王",
        "班",
        "球",
        "琴",
        "甚么",
        "甚至",
        "甚至是",
        "甚麼",
        "甚麽",
        "生",
        "用",
        "由",
        "由于",
        "由於",
        "电",
        "男",
        "町",
        "画",
        "界",
        "畔",
        "畫",
        "當",
        "當中",
        "當屆",
        "病",
        "症",
        "癌",
        "癖",
        "發展",
        "發育",
        "的",
        "的話",
        "的话",
        "皮",
        "盃",
        "监管",
        "盖因",
        "監管",
        "目",
        "直到",
        "直至",
        "相对",
        "相對",
        "相比",
        "省",
        "看",
        "看似",
        "看得",
        "眼",
        "眾",
        "眾多",
        "着",
        "督",
        "瞭",
        "短",
        "石",
        "矿",
        "码",
        "砲",
        "硅",
        "碑",
        "碱",
        "碼",
        "礁",
        "礦",
        "礼",
        "社",
        "祂",
        "神",
        "祠",
        "禮",
        "离",
        "离开",
        "秀",
        "私交",
        "秋",
        "种",
        "科",
        "秤",
        "稅",
        "税",
        "種",
        "突感",
        "窑",
        "窟",
        "窯",
        "站",
        "端",
        "競選",
        "符",
        "笨",
        "等",
        "管",
        "管理",
        "箱",
        "節",
        "篇",
        "籍",
        "米",
        "类",
        "粉",
        "精",
        "糖",
        "系",
        "紀",
        "紅",
        "紋",
        "純",
        "紙",
        "級",
        "素",
        "組",
        "結",
        "給",
        "綉",
        "經",
        "經由",
        "經過",
        "綜",
        "綫",
        "綱",
        "網",
        "線",
        "緣",
        "縣",
        "縱使",
        "總",
        "繞",
        "繼",
        "红",
        "级",
        "纪",
        "纯",
        "纲",
        "纵使",
        "纸",
        "纹",
        "线",
        "组",
        "经",
        "经由",
        "经过",
        "结",
        "绕",
        "给",
        "绣",
        "继",
        "综",
        "网",
        "罩",
        "罪",
        "署",
        "羊",
        "美",
        "群",
        "翁",
        "老",
        "者",
        "而",
        "而且",
        "而已",
        "而是",
        "而非",
        "聖",
        "肉",
        "肯",
        "肺",
        "胎",
        "胚",
        "胶",
        "能",
        "能否",
        "能够",
        "能夠",
        "脚",
        "脸",
        "腔",
        "腳",
        "腿",
        "膜",
        "膠",
        "臉",
        "臨",
        "自",
        "自从",
        "自家",
        "自己",
        "自從",
        "自我",
        "自身",
        "至",
        "至于",
        "至於",
        "臺",
        "與",
        "與其",
        "舊",
        "舞",
        "舟",
        "舰",
        "舱",
        "船",
        "艇",
        "艙",
        "艦",
        "色",
        "节",
        "花",
        "若",
        "若是",
        "茶",
        "药",
        "莊",
        "获利",
        "菌",
        "菜",
        "营",
        "葉",
        "著",
        "蓋因",
        "蓝",
        "藉",
        "藉助",
        "藉由",
        "藉著",
        "藍",
        "藤",
        "藥",
        "藩",
        "處",
        "號",
        "虽",
        "虽则",
        "虽然",
        "蛙",
        "行",
        "術",
        "街",
        "衛",
        "衣",
        "表",
        "表现",
        "表現",
        "表示",
        "被",
        "装",
        "裏",
        "裔",
        "裙",
        "裝",
        "裡",
        "裡面",
        "裤",
        "製",
        "褲",
        "要",
        "要不要",
        "要么",
        "要是",
        "要求",
        "親",
        "覺得",
        "觀",
        "观",
        "觉得",
        "角",
        "計劃",
        "記",
        "詞",
        "試圖",
        "詩",
        "話",
        "該",
        "該屆",
        "該批",
        "該族",
        "該條",
        "該段",
        "該組",
        "該集",
        "該項",
        "誌",
        "認為",
        "認識",
        "語",
        "誤信",
        "說",
        "誰",
        "課",
        "請",
        "論",
        "諸",
        "諸如",
        "謂",
        "證",
        "譜",
        "變",
        "變得",
        "认为",
        "认识",
        "记",
        "许多",
        "许许多多",
        "论",
        "证",
        "词",
        "诗",
        "话",
        "该",
        "该届",
        "该批",
        "该族",
        "该条",
        "该段",
        "该组",
        "该集",
        "语",
        "误信",
        "说",
        "请",
        "诸",
        "诸如",
        "课",
        "谁",
        "谓",
        "谱",
        "谷",
        "豆",
        "象",
        "貓",
        "負債",
        "費",
        "資",
        "賣",
        "質",
        "賽",
        "负债",
        "质",
        "费",
        "资",
        "赛",
        "起",
        "起伏",
        "起来",
        "趁",
        "超",
        "趋",
        "趋于",
        "趨",
        "趨於",
        "距",
        "距离",
        "距離",
        "跟",
        "路",
        "躁",
        "身",
        "車",
        "軍",
        "軒",
        "軟",
        "軸",
        "較",
        "輕",
        "车",
        "轩",
        "软",
        "轴",
        "轻",
        "较",
        "辦",
        "辦學",
        "边",
        "达到",
        "过",
        "过后",
        "运作",
        "近",
        "还",
        "还是",
        "还有",
        "这",
        "这些",
        "这儿",
        "这养",
        "这样",
        "这次",
        "这种",
        "这里",
        "远",
        "连",
        "连任",
        "连同",
        "迷",
        "追溯",
        "透过",
        "透過",
        "這",
        "這些",
        "這個",
        "這兒",
        "這樣",
        "這樣子",
        "這次",
        "這種",
        "這裏",
        "這裡",
        "這邊",
        "這麼",
        "通",
        "通过",
        "通過",
        "逢",
        "連",
        "連任",
        "連同",
        "週",
        "運作",
        "過",
        "過後",
        "道",
        "達到",
        "遠",
        "選舉",
        "還是",
        "邊",
        "那",
        "那个",
        "那些",
        "那儿",
        "那兒",
        "那样",
        "那樣",
        "那裏",
        "那裡",
        "那邊",
        "那里",
        "邦",
        "邨",
        "郎",
        "郡",
        "部",
        "都",
        "都是",
        "鄉",
        "配",
        "酒",
        "酸",
        "醣",
        "醫",
        "里",
        "里面",
        "重",
        "量",
        "金",
        "針",
        "針對",
        "銘",
        "鋼",
        "錄",
        "錦",
        "鍋",
        "鍵",
        "鎊",
        "鎮",
        "鏈",
        "鏡",
        "鐵",
        "鑒於",
        "针",
        "针对",
        "钢",
        "铁",
        "铭",
        "链",
        "锅",
        "锦",
        "键",
        "镇",
        "镜",
        "長",
        "长",
        "門",
        "開口",
        "開始",
        "間",
        "閣",
        "閣下",
        "關",
        "關心",
        "關於",
        "门",
        "间",
        "阁",
        "队",
        "阶",
        "际",
        "陆",
        "降解",
        "院",
        "除",
        "除了",
        "除外",
        "除非",
        "陵",
        "陸",
        "隊",
        "階",
        "随",
        "随同",
        "隔",
        "際",
        "隨",
        "隨同",
        "难过",
        "集",
        "雖",
        "雖則",
        "雖然",
        "離",
        "離開",
        "難過",
        "電",
        "需",
        "需要",
        "非",
        "靠",
        "面",
        "音",
        "頂",
        "須",
        "頭",
        "頭個",
        "題",
        "額",
        "願意",
        "類",
        "顯",
        "顯得",
        "顶",
        "须",
        "题",
        "额",
        "風",
        "风",
        "飯",
        "餅",
        "餐",
        "館",
        "饃",
        "首先",
        "點",
    ],
}
