#-------------------------------------------------------------------------------
# Name:        module1
# Purpose:
#
# Author:      Aaron
#
# Created:     07/08/2023
# Copyright:   (c) Aaron 2023
# Licence:     <your licence>
#-------------------------------------------------------------------------------

import gradio as gr
import sys
import os
import requests
import json
import random
import time

css = """
.btn { background: #f0f0f0 !important;  color: #5268a5 !important;}
.btn:hover { background: #821134 !important; color: #fff !important;}
"""

with gr.Blocks() as demo:
    chatbot = gr.Chatbot()
    msg = gr.Textbox(label="请提问知识产权相关问题！")
    btn = gr.Button(value="提问",interactive=True)


    def respond(message, chat_history):
        btn.interactive=False
        url=os.getenv("LONGMAO_CHAT_URL")
        data={
                "query":message,
            }
        headers = {'Content-Type': 'application/json'}
        bot_message = random.choice(["服务器连接错误，请稍后再试。", "远程服务器响应超时。", "你好，你的问题我不知道。"])
        with requests.post( url,json=data) as   response:
            if response.status_code == 200:
               data=json.loads(response.content)
               bot_message=data["result"]

        chat_history.append((message, bot_message))
        btn.interactive=True
        return "", chat_history

    msg.submit(respond, [msg, chatbot], [msg, chatbot])
    btn.click(respond, [msg, chatbot],[msg, chatbot],queue=False)

if __name__ == "__main__":
    demo.launch()


