from streamlit_webrtc import webrtc_streamer
import numpy as np
import streamlit as st

import numpy as np
import av
import threading

from utils.frame_rate import FrameRate

lock = threading.Lock()

rtc_configuration = {
    "iceServers": [
        {
            "urls": "turn:relay1.expressturn.com:3478",
            "username": "efBRTY571ATWBRMP36",
            "credential": "pGcX1BPH5fMmZJc5",
        },
        # {
        #     "urls": [
        #         "stun:stun1.l.google.com:19302",
        #         "stun:stun2.l.google.com:19302",
        #         "stun:stun3.l.google.com:19302",
        #         "stun:stun4.l.google.com:19302",
        #     ]
        # },
    ],
}


class ImgContainer:
    img: np.ndarray = None  # raw image
    frame_rate: FrameRate = FrameRate()


def video_frame_callback(frame: av.VideoFrame) -> av.VideoFrame:
    img = frame.to_ndarray(format="bgr24")
    with lock:
        img_container.img = img
        img_container.frame_rate.count()
        img = img_container.frame_rate.show_fps(img)
    return av.VideoFrame.from_ndarray(img, format="bgr24")


img_container = ImgContainer()
img_container.frame_rate.reset()
ctx = st.session_state.ctx = webrtc_streamer(
    key="snapshot",
    video_frame_callback=video_frame_callback,
    rtc_configuration=rtc_configuration,
)
