from typing import List, Optional

import numpy as np
from pandas import DataFrame

from .frame_rate import FrameRate


class ImgContainer:
    def __init__(self, frames_per_video: int = 8, is_recording: bool = False) -> None:
        self.img: Optional[np.ndarray] = None  # raw image
        self.frame_rate: FrameRate = FrameRate()
        self.imgs: List[np.ndarray] = []
        self.frames_per_video = frames_per_video
        self.rs: Optional[DataFrame] = None
        self.is_recording = is_recording

    def add_frame(self, frame: np.ndarray) -> None:
        if len(self.imgs) >= self.frames_per_video:
            self.imgs.pop(0)
        self.imgs.append(frame)

    def toggle_recording(self) -> None:
        self.is_recording = not self.is_recording

    @property
    def ready(self):
        return len(self.imgs) == self.frames_per_video
