import time
from typing import Optional

import cv2
import numpy as np
from PIL import Image, ImageDraw, ImageFont


class FrameRate:
    def __init__(self) -> None:
        self.c: int = 0
        self.start_time: Optional[float] = None
        self.NO_FRAMES = 10
        self.fps: float = -1
        self.label: str = ""
        self.font = ImageFont.truetype("fonts/arial.ttf", 50)
        self.reset()

    def reset(self) -> None:
        self.start_time = time.time()
        self.c = 0
        self.fps = -1

    def count(self) -> None:
        self.c += 1
        if self.c % self.NO_FRAMES == 0:
            self.c = 0
            end_time = time.time()
            self.fps = self.NO_FRAMES / (end_time - self.start_time)
            self.start_time = end_time

    def show_fps(self, image: np.ndarray, is_recording=False) -> np.ndarray:
        if self.fps != -1:
            text = f"FPS {self.fps:.0f} _ {self.label}"
            # image = cv2.putText(
            #     image,
            #     text,
            #     (50, 50),
            #     cv2.FONT_HERSHEY_SIMPLEX,
            #     fontScale=1,
            #     color=(255, 0, 0),
            #     thickness=2,
            # )
            pil_image = Image.fromarray(image)
            draw = ImageDraw.Draw(pil_image)
            draw.text((50, 50), text, font=self.font, fill=(0, 0, 204))
            image = np.asarray(pil_image)

            if is_recording:
                image = cv2.circle(
                    image, (50, 100), radius=10, color=(0, 0, 255), thickness=-1
                )
            return image
        else:
            return image
