import gradio as gr
import os
from transformers import pipeline, AutoTokenizer, AutoModelForSequenceClassification
import json
import socket
from datetime import datetime
import huggingface_hub
from huggingface_hub import Repository
import os

access_token = os.environ['ACCES_TOKEN']
edit_token = os.environ['EDIT_TOKEN']

DATASET_REPO_URL = "https://huggingface.co/datasets/EkhiAzur/Demoko_informazioa"
DATA_FILENAME = "Erabiltzaileak.txt"
DATA_FILE = os.path.join("data", DATA_FILENAME)


model = AutoModelForSequenceClassification.from_pretrained("EkhiAzur/C1_Sailkapen_Demoa", token=access_token)

tokenizer = AutoTokenizer.from_pretrained(
  "EkhiAzur/C1_Sailkapen_Demoa",
  token = access_token,
  use_fast=True,
  add_prefix_space=True,
)

classifier = pipeline("text-classification", tokenizer=tokenizer, model=model, max_length=512,
                padding=True, truncation=True, batch_size=1)

adibideak = json.load(open("./Adibideak.json", "r"))

def prozesatu(Testua, request: gr.Request):
    
    repo = Repository(
        local_dir="data", clone_from=DATASET_REPO_URL, use_auth_token=edit_token
    )
    
    #Ip-a lortzeko kontuak
    client_ip = request.client.host
    local_ip = socket.gethostbyname(socket.gethostbyname(""))
    headers = request.kwargs['headers']
    if headers and 'x-forwarded-for' in headers:
        x_forwarded_for = headers['x-forwarded-for']
        client_ip = x_forwarded_for.split(' ')[0] if x_forwarded_for else ""

    # Eguna eta ordua lortu
    now = datetime.now()

    #Fitxategian gorde
    f = open(DATA_FILE, "a")
    print(f'Erabiltzailea: {client_ip}. Eguna eta ordua: {now}.\n')
    f.write(f'Erabiltzailea: {client_ip}. Eguna eta ordua: {now}.\n')

    f.close()
    
    commit_url = repo.push_to_hub()
    
    prediction = prozesatu.classifier(Testua)[0]
    if prediction["label"]=="GAI":
        return {"Gai":prediction["score"], "Ez gai": 1-prediction["score"]}
    else:
        return {"Gai":1-prediction["score"], "Ez gai": prediction["score"]}

def testua_itzuli(testua):
    if testua not in testua_itzuli.adibideak:
        return ""
    return testua_itzuli.adibideak[testua]
    
testua_itzuli.adibideak = adibideak
prozesatu.adibideak = adibideak
prozesatu.classifier = classifier

def ezabatu(Testua):
  return ""

with gr.Blocks() as demo:
  with gr.Row():
    with gr.Column():
      input = gr.Textbox(label="Testua")
      with gr.Row():
        bidali_btn = gr.Button("Bidali")
        ezabatu_btn = gr.Button("Ezabatu")
    
    label = gr.Label(num_top_classes=2, label="C1 maila")
  
  bidali_btn.click(fn=prozesatu, inputs=input, outputs=label)
  ezabatu_btn.click(fn=ezabatu, inputs=input, outputs=input)
    
  gr.Examples(list(adibideak.keys()), inputs=input, outputs=input, label="Adibideak:", fn=testua_itzuli, cache_examples=True)

demo.launch()