from fastai.vision.all import *
import gradio as gr


# Cargamos el learner
learn = load_learner('exportdefinitivo.pkl')

# Definimos las etiquetas de nuestro modelo
labels = ['0','1','2','-1']


# Definimos una función que se encarga de llevar a cabo las predicciones
def predict(string):
    pred,pred_idx,probs = learn.predict(string)
    return {labels[i]: float(probs[i]) for i in range(len(labels))}
    
# Creamos la interfaz y la lanzamos. 
gr.Interface(fn=predict, inputs=gr.inputs.Textbox(lines=1), outputs=gr.outputs.Label(num_top_classes=3),examples=['This house is very good','Going up gets you down'], title="Hypothesis deductor labels entailment, contradiction, and neutral, supporting the task of natural language inference", description="For each instance, there is a string for the premise, a string for the hypothesis, and an integer for the label. pairs manually labeled for balanced classification with the labels entailment(0), contradiction(2), and neutral(1), supporting the task of natural language inference").launch(share=False)