import string

INFINITE = 10000


class Paragraph:

    def __init__(self, xparagraph, doc_id: int, id_: int):

        self.xparagraph = xparagraph
        self.id_ = int(str(2)+str(doc_id)+str(id_))
        name = self.xparagraph.style.name
        self.level = int(name.split(' ')[-1]) if 'Heading' in name else INFINITE
        self.is_structure = self.level < INFINITE
        self.text = self.xparagraph.text

    @property
    def structure(self):
        structure = {str(self.id_): {
            'index': str(self.id_),
            'canMove': True,
            'isFolder': False,
            'children': [],
            'title': self.text,
            'canRename': True,
            'data': {},
            'level': self.level,
        }}
        return structure

    @property
    def blank(self):
        """
        checks if the paragraph is blank: i.e. it brings some signal (it may otherwise be ignored)
        """
        text = self.text.replace('\n', '')
        return set(text).isdisjoint(string.ascii_letters)
