import pandas as pd
import os
from langchain.llms import OpenAI
import chromadb

from config import *
from src.control.control import Controller
from src.tools.retriever import Retriever
from src.tools.llm import LlmAgent
from src.model.doc import Doc
import src.view.view as view

os.environ["TOKENIZERS_PARALLELISM"] = "true"

if not "OPENAI_API_KEY" in os.environ:
    from config_key import OPENAI_API_KEY
    os.environ['OPENAI_API_KEY'] = OPENAI_API_KEY

doc_content = Doc(content_en_path)
doc_plan = Doc(plan_path)
doc_content_fr = Doc(content_fr_path)

client_db = chromadb.Client()
retriever = Retriever(client_db, doc_plan, doc_content, doc_content_fr, collection_name)

llm_model = OpenAI(temperature=0)
llm = LlmAgent(llm_model)

specials['remote_rate_df'] = pd.read_csv(specials['remote_rate_path'])
specials['accommodation_meal_df'] = pd.read_csv(specials['accommodation_meal_path'])
controller = Controller(retriever=retriever, llm=llm, content_language=content_language, plan_language=plan_language,
                        specials=specials)

qna = view.run(ctrl=controller, config=view_config)

qna.queue().launch()
