import unittest
import os

from src.domain.doc import Doc
from src.domain.styles import Styles
from src.domain.container import Container
from src.domain.paragraph import Paragraph


def test_centered_tables(doc):
    for table in doc.xdoc.tables:
        if table.alignment != 1:
            return False
    return True


class Test(unittest.TestCase):

    def test_centered_tables(self):
        doctotest = Doc(path="test/files_to_test/tables/is_centered.docx")
        tempdoc = doctotest.copy("test/files_to_test/tables/is_centered_copy.docx")
        tempdoc.save_as_docx()
        self.assertFalse(test_centered_tables(doctotest))
        doctotest.center_tables()
        doctotest.save_as_docx()
        self.assertTrue(test_centered_tables(doctotest))
        os.remove(doctotest.path)
        tempdoc.save_as_docx("test/files_to_test/tables/is_centered.docx")

    def test_centered_tables_within_text(self):
        doctotest = Doc(path="test/files_to_test/tables/centered_within_text.docx")
        tempdoc = doctotest.copy("test/files_to_test/tables/centered_within_text_copy.docx")
        tempdoc.save_as_docx()
        self.assertFalse(test_centered_tables(doctotest))
        doctotest.center_tables()
        doctotest.save_as_docx()
        self.assertTrue(test_centered_tables(doctotest))
        os.remove(doctotest.path)
        tempdoc.save_as_docx("test/files_to_test/tables/centered_within_text.docx")

    def test_noimage(self):
        counter = 0
        doctest = Doc(path="test/files_to_test/images/0_image.docx")
        for p in doctest.get_paragraphs():
            if p.contains_image():
                counter += 1
        self.assertEqual(counter, 0)
    
    def test_containsimage(self):
        counter = 0
        doctest = Doc(path="test/files_to_test/images/1_image.docx")
        for p in doctest.get_paragraphs():
            if p.contains_image():
                counter += 1
        self.assertEqual(counter, 1)
    
    def test_someimages(self):
        counter = 0
        doctest = Doc(path="test/files_to_test/images/2_images.docx")
        for p in doctest.get_paragraphs():
            if p.contains_image():
                counter += 1
        self.assertEqual(counter, 2)

if __name__ == '__main__':
    unittest.main()