import docx
from docx.enum.style import WD_STYLE_TYPE
import os
from config import config
from typing import Dict
import random
import datetime
import string

from lxml import etree

from src.domain.doc import Doc




name = 'CorpTemplate.docx'

template_path = config['templates_path'] + '/' + config['templates'][config['default_template_index']]
template = Doc(template_path)
doc_path = config['these_docs_path'] + name
this_doc = Doc(path=doc_path)
new_doc_path = config['new_docs_path'] + this_doc.name + '_.docx'
new_doc = this_doc.copy(new_doc_path)




new_styles = new_doc.styles.xstyles
print(etree.tostring(new_styles['.Titre1'].element))
names = new_doc.styles.names
print(names)
new_doc.save_as_docx()


s = template.styles.xstyles['.BodyText']
# new_styles.add_style(s.name, WD_STYLE_TYPE.PARAGRAPH)


list_styles = [(s, s.name) for s in template.styles.xstyles if s.type==WD_STYLE_TYPE.LIST]


base_styles_set = set()
for s in new_styles:
    if s.type == 1:
        if s.base_style:
            try:
                base_styles_set.add(s.base_style.name)
            except:
                print(f"failure for {s}")


base_styles = list(base_styles_set)




"""
or p in new_doc.xdoc.paragraphs:
    if p.style == new_styles['_newBody__2']:
        p.style = s.name

new_styles['_newBody__2'].delete()
new_doc.save_as_docx()
"""
pass
etree.tostring(list_styles[1][0].element)