from typing import Dict

from config import config


def create_msg_from(logs: [Dict], docs) -> str:
    log_messages = []
    log_msg = config['log_msg']
    docs_seen = []
    msg = ''
    for doc in docs:
        for log in logs:
            if doc.name in log.keys():
                log = log[doc.name]
                if 'options_applied' in log.keys():
                    msg += log_msg['options_applied']
                    for option in log['options_applied']:
                        msg += "  -   " + option + "\n"
                if 'suppressed_styles' in log.keys():
                    if log['suppressed_styles']:
                        msg += log_msg['suppressed_styles']
                        for style_name in log['suppressed_styles']:
                            msg += "  -   " + style_name + "\n"
                    if log['modified_styles']:
                        msg += log_msg['modified_styles']
                        for style, log_s in log['modified_styles']:
                            msg += log_msg['modified_style'] + style + "\n"
                            for modif, _ in log_s:
                                msg += log_msg[modif] + ' '
                            msg += '\n'
                    if log['added_styles']:
                        msg += log_msg['added_styles']
                        for style_name in log['added_styles']:
                            msg += "  -   " + style_name + "\n"
                if 'style_mapping' in log.keys():
                    msg = log['style_mapping']
                if msg:
                    if doc not in docs_seen:
                        msg = log_msg['document'] + doc.name + '\n' + msg
                        docs_seen.append(doc)
                    log_messages.append(msg)
                    msg = ''
    log_messages_str = '\n'.join(log_messages)
    return log_messages_str

