from PIL import Image
import os

def get_positions(xml_file):
    i = 0
    width = xml_file.split('cx="')
    height = xml_file.split('cy="')
    while(i < len(width)):
        temp = width[i].split('"')[0]
        if(temp.isnumeric()):
                width = temp
                break
        else:
            i+=1
    i = 0
    while(i < len(height)):
        temp = height[i].split('"')[0]
        if(temp.isnumeric()):
                height = temp
                break
        else:
            i+=1
    return width, height

def convert_to_png(imageslist):
    for image in imageslist:
        if(image.endswith('.png')):
            continue
        im = Image.open(image)
        im.save(image.split('.')[0]+'.png')
        imageslist[imageslist.index(image)] = image.split('.')[0]+'.png'
        os.remove(image)
    return imageslist
     

def get_difference_with_template(styles_used_in_doc, template):
    styles_used_in_template = template.styles.names
    different_styles = []
    for style in styles_used_in_doc:
        if style not in styles_used_in_template:
            different_styles.append(style)
    return different_styles