import string

INFINITE = 10000


class Paragraph:

    def __init__(self, xparagraph, doc_id: int, id_: int):

        self.xparagraph = xparagraph
        self.id_ = int(str(2) + str(doc_id) + str(id_))
        self.level = self.get_level_from_name()
        self.is_structure = self.level < INFINITE
        self.text = self.xparagraph.text
        self.type = self.get_type()

    @property
    def structure(self):
        structure = {str(self.id_): {
            'index': str(self.id_),
            'canMove': True,
            'isFolder': False,
            'children': [],
            'title': self.text,
            'canRename': True,
            'data': {},
            'level': self.level,
        }}
        return structure

    @property
    def blank(self):
        """
        checks if the paragraph is blank: i.e. it brings some signal (it may otherwise be ignored)
        """
        text = self.text.replace('\n', '')
        return set(text).isdisjoint(string.ascii_letters)

    def get_level_from_name(self) -> int:
        style_name = self.xparagraph.style.name
        level = INFINITE
        if '.Titre' in style_name:
            suffix = style_name[-1]
            try:
                level = int(suffix)
            except:
                pass
        return level


