from docx.enum.style import WD_STYLE_TYPE
from docx.shared import RGBColor


class Styles:

    def __init__(self, xstyles, doc_id=0, id_=0):

        self.id_ = int(str(doc_id)+str(id_))
        self.xstyles = xstyles
        self.names = [s.name for s in xstyles]

    @staticmethod
    def copy_style(src=None, dest=None) -> {}:
        modified_style = set()
        if src.type == WD_STYLE_TYPE.PARAGRAPH:
            same_color = True
            if src.font.color.rgb:
                dest_rgb = RGBColor(src.font.color.rgb[0], src.font.color.rgb[1], src.font.color.rgb[2])
                if dest.font.color.rgb:
                    for i in range(3):
                        same_color *= dest.font.color.rgb[i] == dest_rgb[i]
                else:
                    same_color = False
                dest.font.color.rgb = dest_rgb
            else:
                if dest.font.color.rgb:
                    same_color = False
            if not same_color:
                modified_style.add(('color', True))

            if dest.font.size != src.font.size:
                dest.font.size = src.font.size
                modified_style.add(('font size', (src.font.size, dest.font.size)))

            if dest.font.name != src.font.name:
                dest.font.name = src.font.name
                modified_style.add(('font', (src.font.name, dest.font.name)))

            if dest.font.all_caps != src.font.all_caps:
                dest.font.all_caps = src.font.all_caps
                modified_style.add(('all_caps', (src.font.all_caps, dest.font.all_caps)))

            if dest.font.bold != src.font.bold:
                dest.font.bold = src.font.bold
                modified_style.add(('bold', (src.font.bold, dest.font.bold)))

            dest.font.complex_script = src.font.complex_script
            dest.font.cs_bold = src.font.cs_bold
            dest.font.cs_italic = src.font.cs_italic
            dest.font.double_strike = src.font.double_strike
            dest.font.emboss = src.font.emboss
            dest.font.hidden = src.font.hidden
            dest.font.highlight_color = src.font.highlight_color
            dest.font.imprint = src.font.imprint
            dest.font.italic = src.font.italic
            dest.font.math = src.font.math
            dest.font.no_proof = src.font.no_proof
            dest.font.outline = src.font.outline
            dest.font.rtl = src.font.rtl
            dest.font.shadow = src.font.shadow
            dest.font.small_caps = src.font.small_caps
            dest.font.snap_to_grid = src.font.snap_to_grid
            dest.font.spec_vanish = src.font.spec_vanish
            dest.font.strike = src.font.strike
            dest.font.subscript = src.font.subscript
            dest.font.superscript = src.font.superscript
            dest.font.underline = src.font.underline
            dest.font.web_hidden = src.font.web_hidden
            dest.base_style = src.base_style
            dest.hidden = src.hidden
            dest.locked = src.locked
            dest.name = src.name
            dest.priority = src.priority
            dest.quick_style = src.quick_style
            dest.unhide_when_used = src.unhide_when_used
        return modified_style

    def apply_from(self, template_styles, options_list):

        if(options_list == []):
            log = {'suppressed_styles': [], 'modified_styles': [], 'added_styles': []}
        else:
            log = {'options_applied': options_list,'suppressed_styles': [], 'modified_styles': [], 'added_styles': []}

        for s in self.xstyles:
            if s.name not in template_styles.names:
                log['suppressed_styles'].append(s.name)
                s.delete()
            else:
                src_style = template_styles.get_style_from_name(s.name)
                log_s = self.copy_style(src=src_style, dest=s)
                if log_s:
                    log['modified_styles'].append((s.name, log_s))

        for s in template_styles.xstyles:
            if not self.contains_style(s):
                log['added_styles'].append(s.name)
                self.xstyles.add_style(s.name, s.type)
                self.copy_style(src=s, dest=self.xstyles[s.name])
        return log


    def copy_one_style(self, src_style, dest_style) -> {}:
        log_msg = \
            f"le style {src_style.name} a été mappé sur le style {dest_style.name} du template"
        log_dict = {'style_mapping': log_msg}
        self.copy_style(dest_style, src_style)
        return log_dict

    def get_style_from_name(self, name: str):
        try:
            s = self.xstyles[name]
        except:
            return None
        return s

    def contains_style(self, style):
        resp = True
        try:
            s = self.xstyles[style.name]
        except:
            try:
                s = self.xstyles[style.name[1:]]
            except:
                resp = False
        return resp



