import os

config = {
    'templates_path': 'data/templates',
    'these_docs_path': 'data/examples/',
    'new_docs_path': 'data/examples/',
    'default_template_index': 0,
    'styled_docs_path': 'temp/styles_files',
    'generated_docs_path': 'temp/generated_files',
    'options': ["Recentrer les tableaux", "Recentrer les images (sauf les flottantes)", "Ajouter le template avant", "Justifier le texte"],
    'max_styles': 300,
    'log_msg': {
        'options_applied': 'Les options suivantes ont été appliquées : \n',
        'suppressed_styles': 'Les styles suivants ont été supprimés : \n',
        'modified_styles': 'Les styles suivants ont été modifiés : \n',
        'added_styles': 'Les styles suivants ont été ajoutés :\n',
        'modified_style': '  - ',
        'color': ' la couleur,',
        'font size': ' la taille de la fonte,',
        'font': ' la fonte,',
        'all_caps': ' les majuscules,',
        'bold': 'le caractère gras',
        'document': '\n============================\n Sur le document : ',
    },
}

templates = [t for t in os.listdir(config['templates_path']) if t.endswith((".docx",))]
config.update({'templates': templates})
