import gradio as gr
from transformers import AutoModelForSequenceClassification, AutoTokenizer, pipeline


class EmotionClassifier:
    def __init__(self, model_name: str):
        self.model = AutoModelForSequenceClassification.from_pretrained(model_name)
        self.tokenizer = AutoTokenizer.from_pretrained(model_name)
        self.pipeline = pipeline(
            "text-classification",
            model=self.model,
            tokenizer=self.tokenizer,
            return_all_scores=True,
        )

    def predict(self, input_text: str):
        pred = self.pipeline(input_text)[0]
        result = {
            "Sadness 😢": pred[0]["score"],
            "Joy 😆": pred[1]["score"],
            "Love 🥰": pred[2]["score"],
            "Anger 🤬": pred[3]["score"],
            "Fear 😨": pred[4]["score"],
            "Surprise 😯": pred[5]["score"],
        }
        return result


def main():
    model = EmotionClassifier("bhadresh-savani/bert-base-uncased-emotion")
    iface = gr.Interface(
        fn=model.predict,
        inputs=gr.inputs.Textbox(
            lines=3,
            placeholder="Please type a sentence, this program will do the sentiment analysis ",
            label="Input Text",
        ),
        outputs="label",
        title="Sentiment Analysis",
        examples=[
            "To be or not to be, that’s a question.",
            "Better a witty fool than a foolish wit.",
            "No matter how long night, the arrival of daylight Association.",
            "The retention will never give up.",
            "My only love sprung from my only hate.",
        ],
    )

    iface.launch()


if __name__ == "__main__":
    main()