import numpy as np
import gradio as gr

def generate_tone(note, octave, duration):
    
    sampling_rate = 48000
    a4_freq, tones_from_a4 = 440, 12 * (octave - 4) + (note - 9)
    frequency = a4_freq * 2 ** (tones_from_a4 / 12)
    audio = np.linspace(0, int(duration), int(duration) * sampling_rate)
    audio = (20000 * np.sin(audio * (2 * np.pi * frequency))).astype(np.int16)
    return sampling_rate, audio

gr.Interface(
    fn=generate_tone,
    inputs=[
        gr.inputs.Dropdown(["C", "C#", "D", "D#", "E", "F", "F#", "G", "G#", "A", "A#", "B"], type="index"),
        gr.inputs.Slider(2, 6, step=1),
        gr.inputs.Textbox(type="number", default=1, label="Duration in seconds"),
    ],
    outputs="audio",
    title="Generate a Musical Tone!"
).launch()