import tensorflow as tf
import numpy as np 
import docx2txt
from tensorflow.keras.preprocessing.sequence import pad_sequences
from tensorflow.keras.layers import Embedding, LSTM, Dense, Bidirectional
from tensorflow.keras.preprocessing.text import Tokenizer
from tensorflow.keras.models import Sequential
from tensorflow.keras.optimizers import Adam
import gradio as gr
import io
import json
from tensorflow.keras.preprocessing.text import tokenizer_from_json



model = tf.keras.models.load_model('my_model.h5')
with open('tokenizer.json') as f:
    data = json.load(f)
    tokenizer = tokenizer_from_json(data)

max_sequence_len = 58
def predictor(seed_text):
# Define total words to predict
	next_words = 10

# Loop until desired length is reached
	for _ in range(next_words):

	# Convert the seed text to a token sequence
		token_list = tokenizer.texts_to_sequences([seed_text])[0]

	# Pad the sequence
		token_list = pad_sequences([token_list], maxlen=max_sequence_len-1, padding='pre')
	
	# Feed to the model and get the probabilities for each index
		probabilities = model.predict(token_list)

	# Get the index with the highest probability
		predicted = np.argmax(probabilities, axis=-1)[0]

	# Ignore if index is 0 because that is just the padding.
		if predicted != 0:
		
		# Look up the word associated with the index. 
			output_word = tokenizer.index_word[predicted]

		# Combine with the seed text
		seed_text += " " + output_word
	return seed_text

# Print the result	
#print(seed_text)

demo = gr.Interface(
    fn=predictor,
    inputs=gr.inputs.Textbox(lines=5, label="Input Text"),
    outputs=gr.outputs.Textbox(label="Generated Text"),
)

demo.launch()