import os
import gradio as gr
from transformers import pipeline

# auth_token = os.environ.get("access_token")
pipeline_en = pipeline(task="text-classification", model="Hello-SimpleAI/chatgpt-qa-detector-roberta") # use_auth_token=auth_token
pipeline_zh = pipeline(task="text-classification", model="Hello-SimpleAI/chatgpt-qa-detector-roberta-chinese")



def predict_en(q,a):
    res = pipeline_en({"text":q, "text_pair":a})
    return res['label'],res['score']

def predict_zh(q,a):
    res = pipeline_zh({"text":q, "text_pair":a})
    return res['label'],res['score']




with gr.Blocks() as demo:
    gr.Markdown("""
                ## ChatGPT Detector 🔬 (QA version)
                Visit our project on Github: [chatgpt-comparison-detection project](https://github.com/Hello-SimpleAI/chatgpt-comparison-detection)<br>
                欢迎在 Github 上关注我们的 [ChatGPT 对比与检测项目](https://github.com/Hello-SimpleAI/chatgpt-comparison-detection)

                We provide three kinds of detectors, all in Bilingual / 我们提供了三个版本的检测器，且都支持中英文:
                - [**QA version / 问答版** (👈 Current / 当前使用)](https://huggingface.co/spaces/Hello-SimpleAI/chatgpt-detector-qa)<br>
                    detect whether an **answer** is generated by ChatGPT for certain **question**, using PLM-based classifiers / 判断某个**问题的回答**是否由ChatGPT生成，使用基于PTM的分类器来开发;
                - [Sinlge-text version / 独立文本版](https://huggingface.co/spaces/Hello-SimpleAI/chatgpt-detector-single)<br>
                    detect whether a piece of text is ChatGPT generated, using PLM-based classifiers / 判断**单条文本**是否由ChatGPT生成，使用基于PTM的分类器来开发;
                - [Linguistic version / 语言学版](https://huggingface.co/spaces/Hello-SimpleAI/chatgpt-detector-ling)<br>
                    detect whether a piece of text is ChatGPT generated, using linguistic features / 判断**单条文本**是否由ChatGPT生成，使用基于语言学特征的模型来开发;
                
                
                """)
    with gr.Tab("English"):
        gr.Markdown("""
                    Note: Providing more text to the `Answer` box can make the prediction more accurate!
                    """)
        q1 = gr.Textbox(lines=2, label='Question',value="What stops a restaurant from noting down my credit card info and using it ? No offense to restaurants . Can be generalized to anyone who I give my credit card info to . Explain like I'm five.")
        a1 = gr.Textbox(lines=5, label='Answer',value="There are a few things that can help protect your credit card information from being misused when you give it to a restaurant or any other business:\n\nEncryption: Many businesses use encryption to protect your credit card information when it is being transmitted or stored. This means that the information is transformed into a code that is difficult for anyone to read without the right key.")
        button1 = gr.Button("🤖 Predict!")
        label1 = gr.Textbox(lines=1, label='Predicted Label 🎃')
        score1 = gr.Textbox(lines=1, label='Prob')
    with gr.Tab("中文版"):
        gr.Markdown("""
                    注意: 在`回答`栏中输入更多的文本，可以让预测更准确哦！
                    """)
        q2 = gr.Textbox(lines=2, label='问题',value="如何评价 OpenAI 的超级对话模型 ChatGPT ？")
        a2 = gr.Textbox(lines=5, label='回答',value="对于OpenAI大力出奇迹的工作，自然每个人都有自己的看点。我自己最欣赏的地方是ChatGPT如何解决 “AI校正(Alignment)“这个问题。这个问题也是我们课题组这两年在探索的学术问题之一。")
        button2 = gr.Button("🤖 预测!")
        label2 = gr.Textbox(lines=1, label='预测结果 🎃')
        score2 = gr.Textbox(lines=1, label='模型概率')

    button1.click(predict_en, inputs=[q1,a1], outputs=[label1,score1])
    button2.click(predict_zh, inputs=[q2,a2], outputs=[label2,score2])

    # Page Count
    gr.Markdown("""
                <center><a href='https://clustrmaps.com/site/1bsdb'  title='Visit tracker'><img src='//clustrmaps.com/map_v2.png?cl=080808&w=a&t=tt&d=ktUWE8eR4IECIc3YleFfET2jTmWd_lB5wdfEnJCnFwc&co=ffffff&ct=808080'/></a></center>
                """)

demo.launch()