import gradio as gr
import torch
from PIL import Image

# Images
torch.hub.download_url_to_file('https://cdn.statically.io/img/fancyodds.com/wp-content/uploads/2021/12/anime-aesthetic-5-1.jpg', 'anime1.jpg')
torch.hub.download_url_to_file('https://alchetron.com/cdn/pandora-hearts-02235ecf-9315-461e-978a-a819922522d-resize-750.png', 'anime2.png')

model = torch.hub.load('yolov5', 'custom', path ='best.pt', force_reload=True,source='local')

def yolo(image, size = 640):
  g = (size/max(image.size))
  image = image.resize((int(x * g) for x in image.size), Image.ANTIALIAS)
  result = model(image)
  result.render()
  return Image.fromarray(result.imgs[0])


inputs = gr.inputs.Image(type = 'pil', label = "Original Image")
outputs = gr.outputs.Image(type = 'pil', label = "Output Image")

judul = "Deteksi wajah anime menggunakan YoloV5"
deskripsi = "<br>Nama dan jumlah anggota kelompok : <ol><li>M. Azis pangestu, 1051914</li><li>Aisyah Sekar Ayu Dzikron, 1908667</li><li>Hernando Dio Palma, 3332190049.</li><li>Ari Fitria, G74180014</li><li>Wildan Rizky Pamungkas, 1910501094</li><li>Andika Candra 191251010</li><li>Rahmatul Fajri 180120201035</li></ol>"
artikel = "<p style='text-align: center'>Grup V kelas Khasanah Ilmi</p>"

examples = [['anime1.jpg'], ['anime2.png']]
gr.Interface(yolo, inputs, outputs, title = judul, description = deskripsi, article = artikel, examples= examples, theme="huggingface").launch(cache_examples=True, enable_queue=True)