import os
#import gradio as gr

os.system('wget -q https://storage.googleapis.com/vakyaansh-open-models/translation_models/indic-en.zip')
os.system('unzip /home/user/app/indic-en.zip')
os.system('wget -q https://storage.googleapis.com/vakyaansh-open-models/translation_models/en-indic.zip')
os.system('unzip /home/user/app/en-indic.zip')
os.system('wget -q https://storage.googleapis.com/vakyaansh-open-models/translation_models/m2m_modified.zip')
os.system('unzip /home/user/app/m2m_modified.zip')
os.system('rm /home/user/app/indic-en.zip')
os.system('rm /home/user/app/en-indic.zip')
os.system('rm /home/user/app/m2m_modified.zip')

os.system('pip uninstall -y numpy')
os.system('pip install numpy')
#os.system('pip uninstall -y numba')
#os.system('pip install numba==0.53')

from fairseq import checkpoint_utils, distributed_utils, options, tasks, utils
import gradio as grd
from inference.engine import Model
indic2en_model = Model(expdir='indic-en')
en2indic_model = Model(expdir='en-indic')
indic2indic_model = Model(expdir='m2m') 

INDIC = {"English": "en", "Assamese": "as", "Bengali": "bn", "Gujarati": "gu", "Hindi": "hi","Kannada": "kn","Malayalam": "ml", "Marathi": "mr", "Odia": "or","Punjabi": "pa","Tamil": "ta", "Telugu" : "te" }


def translate(text, source_lang, dest_lang):
  if source_lang == 'en':
    return en2indic_model.translate_paragraph(text, 'en', INDIC[dest_lang])
  elif dest_lang == 'en':
    return indic2en_model.translate_paragraph(text,  INDIC[source_lang], 'en')
  else:
    return indic2indic_model.translate_paragraph(text, INDIC[source_lang], INDIC[dest_lang])


languages = list(INDIC.keys())

#print(translate('helo how are you'))
ddwn_src = grd.inputs.Dropdown(languages, type="value", default="English", label="Select Source Language")
ddwn_tar = grd.inputs.Dropdown(languages, type="value", default="Hindi", label="Select Target Language")

txt = grd.inputs.Textbox( lines=5, placeholder="Enter Text to translate", default="", label="Enter Text in Source Language")
txt_ouptut = grd.outputs.Textbox(type="auto", label="Translated text in English Language")

example=[['मैं इस वाक्य का हिंदी में अनुवाद करना चाहता हूं','Hindi', 'English'],
        ['আজ আমার খুব ভালো লাগছে', 'Bengali' , 'Hindi']]

supp = ','.join(languages)
iface = grd.Interface(fn=translate, inputs=[txt,ddwn_src,ddwn_tar] , outputs=txt_ouptut, title='Translation for 11 Indic Languages', description = 'This is a demo based on IndicTrans. Languages Supported: '+supp, article = 'Original repo [link](https://github.com/AI4Bharat/indicTrans) by AI4Bharat. <b>Note: This is an attempt to create open version of Translation for Indic languages. </b>', examples=example)
iface.launch(enable_queue=True)
