import os
#import gradio as gr

os.system('wget -q https://storage.googleapis.com/vakyaansh-open-models/translation_models/en-indic.zip')
os.system('unzip /home/user/app/en-indic.zip')
os.system('pip uninstall -y numpy')
os.system('pip install numpy')
#os.system('pip uninstall -y numba')
#os.system('pip install numba==0.53')

from fairseq import checkpoint_utils, distributed_utils, options, tasks, utils
import gradio as grd
from inference.engine import Model
indic2en_model = Model(expdir='en-indic')

INDIC = {"Assamese": "as", "Bengali": "bn", "Gujarati": "gu", "Hindi": "hi","Kannada": "kn","Malayalam": "ml", "Marathi": "mr", "Odia": "or","Punjabi": "pa","Tamil": "ta", "Telugu" : "te"}


def translate(text, lang):
  return indic2en_model.translate_paragraph(text, 'en', INDIC[lang])



languages = list(INDIC.keys())

#print(translate('helo how are you'))
ddwn = grd.inputs.Dropdown(languages, type="value", default="Hindi", label="Select Target Language")
txt = grd.inputs.Textbox( lines=5, placeholder="Enter Text to translate", default="", label="Enter Text in English")
txt_ouptut = grd.outputs.Textbox(type="auto", label="Translated text in Target Language")

example=[['I want to translate this sentence in Hindi','Hindi'],
        ['I am feeling very good today.', 'Bengali']]

supp = ','.join(languages)
iface = grd.Interface(fn=translate, inputs=[txt,ddwn] , outputs=txt_ouptut, title='Translation for 11 Indic Languages', description = 'This is a demo based on IndicTrans. Languages Supported: '+supp, article = 'Original repo [link](https://github.com/AI4Bharat/indicTrans) by AI4Bharat. <b>Note: This space can only perform translation from English to Indic languages. Support for other combinations will be provided soon.', examples=example)
iface.launch(enable_queue=True)
