import gradio as gr
import argparse
import numpy as np
from argparse import Namespace
from .advanced_tts import load_all_models, run_tts_paragraph


def hit_tts(textbox, gender, slider_noise_scale, slider_length_sclae, choice_transliteration, choice_number_conversion, choice_split_sentences):
    inputs_to_gradio = {'text' : textbox,
                        'gender' : gender,
                        'noise_scale': slider_noise_scale,
                        'length_scale': slider_length_sclae,
                        'transliteration' : 1 if choice_transliteration else 0,
                        'number_conversion' : 1 if choice_number_conversion else 0,
                        'split_sentences' : 1 if choice_split_sentences else 0
                        }

    args = Namespace(**inputs_to_gradio)
    args.wav = None
    args.lang = lang
    args.gender = gender

    if args.text:
        sr, audio = run_tts_paragraph(args)
        return (sr, audio)

def build_gradio(args):
    global lang
    lang = args.lang
    load_all_models(args)
    textbox = gr.inputs.Textbox(placeholder="Enter Text to run", default="", label="Enter Input Text")
    gender = gr.inputs.Radio(choices = ['Female', 'Male'], default='Female', label='Gender')
    slider_noise_scale = gr.inputs.Slider(minimum=0, maximum=1.0, step=0.001, default=0.667, label='Noise Scale')
    slider_length_sclae = gr.inputs.Slider(minimum=0, maximum=2.0, step=0.1, default=1.0, label='Length Scale')

    choice_transliteration = gr.inputs.Checkbox(default=True, label="Transliteration")
    choice_number_conversion = gr.inputs.Checkbox(default=True, label="Number Conversion")
    choice_split_sentences = gr.inputs.Checkbox(default=True, label="Split Sentences")

    examples = [['இந்தியா எனது நாடு, நான் இந்தியனாக இருப்பதில் பெருமை கொள்கிறேன்.', 'Male', 0.667, 1, 0, 1, 1]]
   
    op = gr.outputs.Audio(type="numpy", label=None)

    inputs_to_gradio = [textbox, gender, slider_noise_scale, slider_length_sclae, choice_transliteration, choice_number_conversion, choice_split_sentences]
    iface = gr.Interface(fn=hit_tts, examples = examples, inputs=inputs_to_gradio, outputs=op, theme='huggingface', title='Vakyansh Tamil TTS', article = 'Note: Transliteration models may not work well in some scenarios which can hamper the TTS quality, to evaluate the model in better sense it is advisable to provide input in the required language and switch off transliteration. Contact @harveenchadha on twitter for any issues.')
    iface.launch(enable_queue=True)

if __name__ == "__main__":
    parser = argparse.ArgumentParser()
    parser.add_argument("-a", "--acoustic", required=True, type=str)
    parser.add_argument("-v", "--vocoder", required=True, type=str)
    parser.add_argument("-d", "--device", type=str, default="cpu")
    parser.add_argument("-L", "--lang", type=str, required=True)

    global lang

    args = parser.parse_args()    
    lang = args.lang
    
    build_gradio(args)