import gradio as gr
import pickle
import pandas as pd
import warnings
warnings.filterwarnings('ignore')

model = pickle.load(open("hinglish_vs_english_model_no_GPU_2.0.pkl", 'rb')) # version 2.0

def classify_text(text):
    text_to_predict = pd.DataFrame({
        "Text": [
            text
        ]
    })
    predictions, output_directory = model.predict(text_to_predict)
    return list(predictions["Label_predictions"])[0]

inputs = gr.inputs.Textbox(lines=5, label="Enter text", placeholder="Aur bhai, kaisa hai re tu, tune bataya nhi tere kitne marks aaye last examination me")
outputs = gr.outputs.Label(label="Prediction")

gr.Interface(
    fn = classify_text, 
    inputs=inputs, 
    outputs=outputs, 
    title="EngHindi",
    description="Enter some text and get a prediction of whether it's in Hinglish or English.",
    examples = [
        "Hi! Kya haal chaal hai?",
        "How are you doing today?",
        "Aaj ka mausam kaisa hai?",
        "What is the weather like today?",
        "Kya aap mujhe bata sakte hain ki yahaan kahaan se bhojan khana hai?",
        "Can you tell me where to get food around here?",
        "Main aapki help kar sakta hoon.",
        "I can help you with that.",
        "Mujhe ye samajh nahi aa raha hai.",
        "I don't understand this.",
        "Kal raat ko maine bahut der tak kaam kiya tha.",
        "I worked very late last night.",
        "Yeh kya hai?",
        "What is this?",
        "Main yahaan nahi ruk sakta.",
        "I can't stay here.",
        "Aaj meri shaadi hai.",
        "Today is my wedding day.",
        "Kyun aisa karte ho?",
        "The most bad thing about this show was the speech that he gave, so bad.",
        "The shit you hear about me might be true or it might be faker than the bitch who told it to ya",
        "Aur bhai, kaisa hai re tu, tune bataya nhi tere kitne marks aaye last examination me.",
    ],
    theme = "darkhuggingface",
    live = True,
).launch(inline=False)