import streamlit as st
from st_pages import Page, show_pages

# should be
show_pages(
    [
        Page(r"app.py", "Home", "🏠"),
        Page(r"Pages/Topic Model Results.py", "Topic Model Result", "📊"),
        Page(r"Pages/Models.py", "Models", "🤖"),
        Page(r"Pages/About.py", "About", "👋"),
    ]
)

st.set_page_config(
    page_title="Autonomous Text Tagging App",
    page_icon="📝",
    layout="wide",
    initial_sidebar_state="expanded",
)


# Display the main page of the app with instructions on how to use it
def main():
    st.title("Autonomous Text Tagging App")
    cols = st.columns([1, 1])
    with st.container():
        with cols[0]:
            st.write(
                "A Text tagging is the process of adding metadata or labels to specific elements within a text, such as identifying and categorizing named entities, parts of speech, or sentiment."
            )
            st.write(
                "This app show the results of BERTopic Model and a demo of all the models used in this project."
            )
            st.subheader("How to use this app:")
            st.write("1. Select the model you want to use from the sidebar.")
            st.write("2. Enter the text you want to tag.")
            st.write('3. Click on the "Tag" button.')
            st.write("4. The tags will be displayed in the output section.")
            st.write("5. You can see the results of BERTopic Model in the sidebar.")
            st.write("6. You can use tabs to see the visualization of the results.")
            st.divider()

        with cols[1]:
            st.image("Sort.svg", width=450)


if __name__ == "__main__":
    main()
