import streamlit as st


# Display the about page of the app with information about the creator, code and data.
def about_page():
    with st.container():
        col = st.columns([1, 1])
        with col[0]:
            st.title("About Us")
            st.write("\n")
            st.write("\n")
            st.markdown(
                """##### This app was created by [Harshit Singh](https://harsh502s.github.io), Poorvi Singh and Samriddhi Raskar as a part of their MSc Data Science 3rd semester project."""
            )
            st.write("\n")
            st.markdown(
                """##### The code for this app can be found [here](https://github.com/Harsh502s/Autonomous-Text-Tagging-System)""",
                unsafe_allow_html=True,
            )
            st.write("\n")
            st.markdown(
                """##### The data on which these models are trained can be found [here](https://www.kaggle.com/datasets/harsh502s/stackexchange-tag-dataset/data).""",
                unsafe_allow_html=True,
            )
        with col[1]:
            st.image("Group.svg", width=325)

    st.write("\n")
    st.write("\n")

    with st.container():
        col = st.columns([1.5, 2])
        with col[0]:
            st.image("Robot.svg", width=350)
        with col[1]:
            st.title("Models Used:")
            st.markdown(
                """###### 1. BERTopic is a topic modeling technique that leverages BERT embeddings and c-TF-IDF to create dense clusters allowing for easily interpretable topics whilst keeping important words in the topic descriptions."""
            )
            st.markdown(
                """###### 2. KeyBERT is a minimal and easy-to-use keyword extraction technique that leverages BERT embeddings to create keywords and keyphrases that are most similar to a document."""
            )
            st.markdown(
                """###### 3. Convolutional Neural Networks (CNNs) are used for text classification. CNNs can identify patterns in text data, such as bigrams, trigrams, or n-grams. CNNs are translation invariant, so they can detect these patterns regardless of their position in the sentence."""
            )


if __name__ == "__main__":
    about_page()
