import streamlit as st
from streamlit_tags import st_tags, st_tags_sidebar
from keytotext import pipeline
from PIL import Image

############
## Main page
############

st.write("# Code for Keywords to Text")

st.markdown("***Idea is to build a model which will take keywords as inputs and generate information as outputs.***")
image = Image.open('1.png')
st.image(image)
        
st.sidebar.write("# Parameter Selection")
maxtags_sidebar = st.sidebar.slider('Number of tags allowed?', 1, 10, 1, key='ehikwegrjifbwreuk')
keywords = st_tags(
    label='# Enter Keywords:',
    text='Press enter to add more',
    value=['Summer'],
    suggestions=['five', 'six', 'seven', 'eight', 'nine', 'three', 'eleven', 'ten', 'four'],
    maxtags=maxtags_sidebar,
    key="aljnf")

# Add selectbox in streamlit
option = st.sidebar.selectbox(
     'Which model would you like to be selected?',
     ('mrm8488/t5-base-finetuned-common_gen', 'k2t-base', 'k2t'))

#if st.sidebar.button('Load Model'):
#    nlp=pipeline(option)
#    st.sidebar.success("Load Successfully!")
nlp=pipeline(option)
st.sidebar.success("Load Successfully!")

st.write("## Results:")
if st.button('Generate Sentence'):
    out=nlp(keywords)
    st.success(out)
