from fastai.vision.all import *
import gradio as gr
learn = load_learner('petClassify.pkl')
labels = learn.dls.vocab
def predict(img):
    img = PILImage.create(img)
    pred, idx, probs = learn.predict(img)
    return {labels[i] : float(probs[i]) for i in range(len(labels))}


# print(predict('licensed-image.jpeg'))
title = "Pet classifier"
description = "Oxford pets classifier based on fine tuned resnet 50"
article = "Plaintext"
enable_queue = True
interpretation= 'default'
examples = ['licensed-image.jpeg']
gr.Interface(fn=predict, inputs=gr.inputs.Image(shape=(512, 512)), outputs=gr.outputs.Label(num_top_classes=3),
             description=description, title=title, article=article,
             examples=examples, interpretation=interpretation
             ).launch(share=False)