import streamlit as st
import json
from PIL import Image


def load_image(image_path, image_resize=None):
    image = Image.open(image_path)
    if isinstance(image_resize, tuple):
        image.resize(image_resize)
    return image


def load_text(text_path):
    text = ''
    with open(text_path) as f:
        text = f.read()

    return text


def load_json(json_path):
    jdata = ''
    with open(json_path) as f:
        jdata = json.load(f)

    return jdata


def local_css(css_path):
    with open(css_path) as f:
        st.markdown(f'<style>{f.read()}</style>', unsafe_allow_html=True)


def remote_css(css_url):
    st.markdown(f'<link href="{css_url}" rel="stylesheet">', unsafe_allow_html=True)

