import pandas as pd

data = pd.DataFrame(columns=["Dataset", "Alpha", "Top K", "Recall", "Precision"])
data = pd.concat(
    [
        data,
        pd.DataFrame(
            [["ml-100k", 0.1, 20, 0.2, 0.2]],
            columns=["Dataset", "Alpha", "Top K", "Recall", "Precision"],
        ),
    ]
)

import os
import plotly.express as px
import pandas as pd
from dash import Dash, html, dcc, Input, Output, callback
import plotly.express as px
from dataclasses import dataclass
import json

data = pd.DataFrame(columns=["Dataset", "Alpha", "Top K", "Recall", "Precision"])
data = pd.concat(
    [
        data,
        pd.DataFrame(
            [["ml-100k", 0.1, 20, 0.2, 0.2]],
            columns=["Dataset", "Alpha", "Top K", "Recall", "Precision"],
        ),
    ]
)
debug = False


external_stylesheets = ["https://codepen.io/chriddyp/pen/bWLwgP.css"]

app = Dash(__name__, external_stylesheets=external_stylesheets)

server = app.server


dataset_options = [
    {"label": entry, "value": entry} for entry in data["Dataset"].unique()
]
dataset_options_default_value = data["Dataset"].unique()[0]

alpha_options = [{"label": entry, "value": entry} for entry in data["Alpha"].unique()]
alpha_options_default_value = data["Alpha"].unique()[0]

top_k_options = [{"label": entry, "value": entry} for entry in data["Top K"].unique()]
top_k_options_default_value = data["Top K"].unique()[0]

app.layout = html.Div(
    [
        html.H1("System Evaluation"),
        html.Div(
            [
                html.Div(
                    [
                        html.H3("Dataset"),
                        dcc.Dropdown(
                            id="dataset-dropdown",
                            options=dataset_options,
                            value=dataset_options_default_value,
                        ),
                    ],
                    className="three columns",
                ),
                html.Div(
                    [
                        html.H3("Alpha"),
                        dcc.Dropdown(
                            id="alpha-dropdown",
                            options=alpha_options,
                            value=alpha_options_default_value,
                        ),
                    ],
                    className="three columns",
                ),
                html.Div(
                    [
                        html.H3("Top K"),
                        dcc.Dropdown(
                            id="top_k-dropdown",
                            options=top_k_options,
                            value=top_k_options_default_value,
                        ),
                    ],
                    className="three columns",
                ),
            ],
            className="row",
        ),
        html.Div(
            [
                html.Div([dcc.Graph(id="recall-graph")], className="six columns"),
                html.Div([dcc.Graph(id="precision-graph")], className="six columns"),
            ],
            className="row",
        ),
    ]
)


@app.callback(
    Output("recall-graph", "figure"),
    Output("precision-graph", "figure"),
    Input("alpha-dropdown", "value"),
    Input("dataset-dropdown", "value"),
    Input("top_k-dropdown", "value"),
)
def update_graph(alpha, dataset, top_k):
    filtered_data = data[
        (data["Alpha"] == alpha)
        & (data["Dataset"] == dataset)
        & (data["Top K"] == top_k)
    ]
    recall_fig = px.bar(filtered_data, x="Dataset", y="Recall")
    precision_fig = px.bar(filtered_data, x="Dataset", y="Precision")
    return recall_fig, precision_fig


# Run app and display result inline in the notebook
if __name__ == "__main__":
    app.run_server(debug=debug, port=8050)
