# Electric cost(Euros) = energy_price(Euros/kWh) * wasted_energy(kWh)
def custo(energy_price_hour, wasted_energy):
    return energy_price_hour * wasted_energy


# caldeira 20 litros
def spent_energy(
    temperatura_inicial_caldeira_t,  # existente na cadeira, t sendo a hora
    temperatura_objetivo_caldeira_t_plus_1,
    outside_temp,
    pressao_caldeira,
    litros_gastos_no_banho=0,
    temperatura_entrada_agua_na_caldeira=15,  # Temperatura ambiente da iNOVA
    capacidade_caldeira=20,  # 20 litros
):
    # E = (4.2 kJ/kgoC) ((90 oC) - (20 oC)) (1000 liter) (1 kg/liter)
    # cp = specific heat of water (kJ/kgoC, Btu/lb oF) (4.2 kJ/kgoC, 1 Btu/lbmoF for water)
    heat_capacity = 4.2
    # Energy =  heat_capacity * (temperatura_saida_agua_na_caldeira - outside_temp) * capacidade_caldeira * 1\
    delta_t = temperatura_objetivo_caldeira_t_plus_1 - temperatura_inicial_caldeira_t

    energy = (
        heat_capacity
        * (delta_t - outside_temp)
        * (capacidade_caldeira - litros_gastos_no_banho)
        * 1
    )  # isto vai ser minimo

    delta_t = (
        temperatura_objetivo_caldeira_t_plus_1 - temperatura_entrada_agua_na_caldeira
    )
    energy_incoming_water = (
        heat_capacity * (delta_t - outside_temp) * litros_gastos_no_banho * 1
    )

    # 20 Litros totais
    # Joao gatou 5 litros
    # Gastar energia em:
    # 15 litros para manter a temperatura da caldeira -> minimo
    # 5 litros para aquecer a agua que entra

    total_energy = energy + energy_incoming_water

    # TODO: Correlação entre pressão e temperatura
    # https://www.engineeringtoolbox.com/boiling-points-water-altitude-d_1344.html
    # https://www.engineeringtoolbox.com/boiling-point-water-d_926.html
    """
    That depends on whether the pressure is held constant during the heating. If there is a relief valve which maintains 
    constant pressure as the water heats, then no, the 2 samples will heat at the same rate. However, if the pressurised sample 
    has no pressure relief, then it will heat faster because the pressure will increase, and that increase in pressure will increase 
    the heat in addition to the heat applied.
    """
    # kJ

    # TODO: FIND WHAT SHOULD BE THE RELATION BETWEEN TEMPERATURE OF OUTGOING WATER AND BOILER TEMPERATURE
    temperatura_saida_agua_na_caldeira = temperatura_objetivo_caldeira_t_plus_1 * 0.87

    return total_energy, temperatura_saida_agua_na_caldeira


def calculate_weights_for_all_hours(
    temperatura_inicial_caldeira,
    temperatura_objetivo_caldeira,
    outside_temp,
    pressao_caldeira,
    litros_gastos_no_banho,
    temperatura_entrada_agua_na_caldeira,
    capacidade_caldeira,
):
    weights = []
    temperatures = []
    for i in range(len(temperatura_inicial_caldeira)):
        energy, temperature_water = spent_energy(
            temperatura_inicial_caldeira_t=temperatura_inicial_caldeira[i],
            temperatura_objetivo_caldeira_t_plus_1=temperatura_objetivo_caldeira,
            outside_temp=outside_temp[i],
            pressao_caldeira=pressao_caldeira[i],
            litros_gastos_no_banho=litros_gastos_no_banho,
            temperatura_entrada_agua_na_caldeira=temperatura_entrada_agua_na_caldeira[
                i
            ],
            capacidade_caldeira=capacidade_caldeira,
        )
        weights.append(energy)
        temperatures.append(temperature_water)
    return weights, temperatures
    # Output energy wasted


def calculate_confort(temperatura_given, temperatura_ideal):
    return abs(temperatura_given - temperatura_ideal)


# create exception for no solution found
class NoSolutionFound(Exception):
    pass

class SoltionFoundWithLargerConfortValue(Exception):
    pass