import gradio as gr
import transformers
from transformers import pipeline

p = pipeline("text-generation", "EleutherAI/gpt-neo-1.3B")

im2caption = gr.Interface.load("spaces/akhaliq/CLIP_prefix_captioning")

def im2story(img):
    caption = im2caption(img, "COCO")
    caption = caption[0].lower() + caption[1:]
    story = p("Let me tell you a story about " + caption)[0]["generated_text"]
    return story

gr.Interface(im2story, gr.Image(type="filepath"), "text").launch()