import streamlit as st
import cv2
import tempfile
from PIL import Image
import os
from stqdm import stqdm

with st.spinner("Loading model ..."):
    from model import base_inference

f = st.file_uploader("Upload file")

if f is not None:
    with st.spinner():
        tfile = tempfile.NamedTemporaryFile(delete=False) 
        tfile.write(f.read())

        vf = cv2.VideoCapture(tfile.name)

        frame_width = int(vf.get(3))
        frame_height = int(vf.get(4))
        
        size = (frame_width, frame_height)
        
        # Below VideoWriter object will create
        # a frame of above defined The output 
        # is stored in 'filename.avi' file.
        tmp_file_path = 'tmp/video.avi'
        out_file_path = 'tmp/video.mp4'

        cap = cv2.VideoWriter(
            tmp_file_path, 
            cv2.VideoWriter_fourcc('M', 'J', 'P', 'G'),
            10, size
        )
        length = int(vf.get(cv2.CAP_PROP_FRAME_COUNT))

        sod_stframe = st.empty()

        for _ in stqdm(range(length)):
            if not vf.isOpened():
                break

            ret, image = vf.read()
            if not ret:
                break

            pred_depth, pred_sod, _ = base_inference(image, None)
            cap.write(pred_sod)

        vf.release()
        cap.release()

        os.system(f'ffmpeg -y -i {tmp_file_path} -vcodec libx264 {out_file_path} -hide_banner -loglevel error')
        
        video_file = open(out_file_path, 'rb')
        video_bytes = video_file.read()
        st.video(video_bytes, format="video/mp4")
