from typing import Dict, Optional, Union
import wandb
from wandb.sdk.wandb_run import Run
import os
from wandb.apis.public import Run as ApiRun, Artifact

from .configs.base_config import base_cfg

WANDB_PROJECT_NAME = 'RGBD_SOD'

def wandb_login(cfg: base_cfg) -> None:
    wandb.login(key=cfg.wandb_api_key)

def wandb_init(
    name: str,
    config: Union[Dict, str, None] = None
) -> Run:
    return wandb.init(
        name=name, project=WANDB_PROJECT_NAME, 
        id=name, resume='auto', config=config
    )

def wandb_init_sota_benchmark(
    datasets_set: int, 
    additional_name: Optional[str] = None,
) -> Run:
    name = f'SOTAs_v{datasets_set}'
    if additional_name is not None:
        name += f'_{additional_name}'
    return wandb_init(name, config=dict())

def wandb_init_sota_benchmark_sm(datasets_set: int) -> Run:
    return wandb_init(f'SOTAs_SM_v{datasets_set}', config=dict())

# Not working!
def wandb_delete_artifacts(cfg: base_cfg, wandb_run: Run) -> None:
    wandb_api = wandb.Api(api_key=cfg.wandb_api_key)
    try:
        run: ApiRun = wandb_api.run(
            os.path.join(
                wandb_run.entity, 
                wandb_run.project, 
                wandb_run.id,
            )
        )
        for artifact in run.logged_artifacts():
            artifact: Artifact = artifact
            artifact.delete(delete_aliases=True)
    except Exception as e: 
        print('[ERROR] wandb_delete_artifacts', e)