from .configs.base_config import base_cfg

from .train_fns.train_v1 import train_v1
from .train_fns.train_v2 import train_v2
    
def train(cfg: base_cfg) -> None:
    print(f'Use train function version {cfg.train_function_version}')
    if cfg.train_function_version == 1:
        raise Exception('Train function version 1 is deprecated!')
        train_v1(cfg)
    elif cfg.train_function_version == 2:
        train_v2(cfg)
    else:
        raise Exception('Train function version not supported!')
