from typing import List, Optional
from torch.utils.data import DataLoader
from torch import Tensor
import random
import torch, os

from .utils import plot_batch_of_pairs
from .configs.base_config import base_cfg
from .dataset_fn import TrainDataset

def test_rgbd_dataset(cfg: base_cfg) -> None:
    train_dataset = TrainDataset(
        cfg.train_dataset_working_dir_path, cfg.image_size,
        inputs=cfg.inputs, outputs=cfg.outputs,
    )
    train_dataloader = DataLoader(
        train_dataset, batch_size=cfg.batch_size, 
        shuffle=True, num_workers=cfg.num_workers
    )

    for i_batch, (images, depths, gts, indices) in enumerate(train_dataloader):
        print(f'{i_batch}, {images.shape}, {depths.shape},  {indices.shape}')
        plot_batch_of_pairs(images, depths, gts)
        break

def test_data_augmentation(
    cfg: base_cfg,
    data_augmentation_version: int,
    index: Optional[int] = None,
) -> None:
    cfg.data_augmentation_version = data_augmentation_version
    dataset = TrainDataset(cfg)

    images: List[Tensor] = []
    depths: List[Tensor] = []
    gts: List[Tensor] = []
    
    if index is None:
        index = random.randrange(len(dataset))
    print(index)

    # No transformation
    image, depth, gt, i = dataset.__getitem__(index, False)
    print(torch.max(depth), torch.min(depth))
    images.append(torch.unsqueeze(image, 0))
    depths.append(torch.unsqueeze(depth, 0))
    gts.append(torch.unsqueeze(gt, 0))

    # Random 3 times transformation
    for _ in range(5):
        image, depth, gt, i = dataset[index]
        print(torch.max(depth), torch.min(depth))
        images.append(torch.unsqueeze(image, 0))
        depths.append(torch.unsqueeze(depth, 0))
        gts.append(torch.unsqueeze(gt, 0))

    os.makedirs(cfg.latex_dir_path, exist_ok=True)
    plot_batch_of_pairs(
        torch.cat(images),
        torch.cat(depths),
        torch.cat(gts),
        os.path.join(
            cfg.latex_dir_path, 
            f'data_augmentation_v{cfg.data_augmentation_version}.png'
        )
    )

# test_data_augmentation(cfg, index=10)
